/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.undo.UndoableAction;
import org.tigris.gef.util.Localizer;

public class ReorderAction
extends UndoableAction {
    private static final long serialVersionUID = -2190865994915716779L;
    public static final int SEND_TO_BACK = 1;
    public static final int BRING_TO_FRONT = 2;
    public static final int SEND_BACKWARD = 3;
    public static final int BRING_FORWARD = 4;
    public static ReorderAction SendToBack = new ReorderAction(1);
    public static ReorderAction BringToFront = new ReorderAction(2);
    public static ReorderAction SendBackward = new ReorderAction(3);
    public static ReorderAction BringForward = new ReorderAction(4);
    private int function;

    public ReorderAction(int n2) {
        this(ReorderAction.wordFor(n2), n2, false);
    }

    public ReorderAction(String string, int n2) {
        this(string, n2, false);
    }

    public ReorderAction(String string, Icon icon, int n2) {
        this(string, icon, n2, false);
    }

    public ReorderAction(String string, int n2, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
        this.function = n2;
    }

    public ReorderAction(String string, Icon icon, int n2, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
        this.function = n2;
    }

    protected static String wordFor(int n2) {
        switch (n2) {
            case 3: {
                return "Backward";
            }
            case 1: {
                return "ToBack";
            }
            case 4: {
                return "Forward";
            }
            case 2: {
                return "ToFront";
            }
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        super.actionPerformed((ActionEvent)serializable);
        serializable = Globals.curEditor();
        LayerManager layerManager = ((Editor)serializable).getLayerManager();
        serializable = ((Editor)serializable).getSelectionManager();
        ((SelectionManager)serializable).reorder(this.function, layerManager.getActiveLayer());
        ((SelectionManager)serializable).endTrans();
    }
}

