/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.util.Localizer;

public abstract class SaveGraphicsAction
extends AbstractAction {
    private static Log LOG = LogFactory.getLog(LayerDiagram.class);
    protected int scale = 1;
    protected OutputStream outputStream;

    protected abstract void saveGraphics(OutputStream var1, Editor var2, Rectangle var3);

    public SaveGraphicsAction(String string) {
        this(string, false);
    }

    public SaveGraphicsAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public SaveGraphicsAction(String string, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string);
    }

    public SaveGraphicsAction(String string, Icon icon, boolean bl2) {
        super(bl2 ? Localizer.localize("GefBase", string) : string, icon);
    }

    public void setStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setScale(int n2) {
        this.scale = n2;
    }

    @Override
    public void actionPerformed(ActionEvent serializable) {
        serializable = Globals.curEditor();
        Rectangle rectangle = ((Editor)serializable).getLayerManager().getActiveLayer().calcDrawingArea();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Bounding box: ".concat(String.valueOf(rectangle)));
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Graphics generation aborted.");
            }
            return;
        }
        boolean bl2 = ((Editor)serializable).getGridHidden();
        ((Editor)serializable).setGridHidden(true);
        try {
            SaveGraphicsAction saveGraphicsAction = this;
            saveGraphicsAction.saveGraphics(saveGraphicsAction.outputStream, (Editor)serializable, rectangle);
        }
        catch (IOException iOException) {
            LOG.error((Object)"Error while exporting Graphics:", (Throwable)iOException);
        }
        ((Editor)serializable).setGridHidden(bl2);
    }
}

