/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Icon;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.ModeModify;
import org.tigris.gef.base.SelectionResize;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public abstract class SelectionButtons
extends SelectionResize {
    private static final int IMAGE_SIZE = 22;
    private static final int MARGIN = 2;
    private static final Color PRESSED_COLOR = Color.gray.brighter();
    private static final int MAX_PLACINGS = 1;
    private static int numButtonClicks = 0;
    private static boolean showRapidButtons = true;
    private boolean paintButtons = showRapidButtons;
    private int pressedButton = -1;
    private int placeCounter = 0;

    public SelectionButtons(Fig fig) {
        super(fig);
    }

    public static void toggleShowRapidButtons() {
        showRapidButtons = !showRapidButtons;
    }

    public boolean hitAbove(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        return this.intersectsRect(rectangle, n2 - n4 / 2, n3 - n5 - 2, n4, n5 + 2);
    }

    public boolean hitBelow(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        return this.intersectsRect(rectangle, n2 - n4 / 2, n3, n4, n5 + 2);
    }

    public boolean hitLeft(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        return this.intersectsRect(rectangle, n2 - n4 - 2, n3 - n5 / 2, n4 + 2, n5);
    }

    public boolean hitRight(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        return this.intersectsRect(rectangle, n2, n3 - n5 / 2, n4 + 2, n5);
    }

    public boolean intersectsRect(Rectangle rectangle, int n2, int n3, int n4, int n5) {
        return rectangle.x + rectangle.width > n2 && rectangle.y + rectangle.height > n3 && rectangle.x < n2 + n4 && rectangle.y < n3 + n5;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.paintButtons) {
            return;
        }
        Editor editor = Globals.curEditor();
        if (editor.getSelectionManager().size() != 1) {
            return;
        }
        if (editor.getModeManager().includes(ModeModify.class) && this.pressedButton == -1) {
            return;
        }
        this.paintButtons(graphics);
    }

    public abstract void paintButtons(Graphics var1);

    public void paintButtonAbove(Icon icon, Graphics graphics, int n2, int n3, int n4) {
        this.paintButton(icon, graphics, n2 - icon.getIconWidth() / 2, n3 - icon.getIconHeight() - 2, n4);
    }

    public void paintButtonBelow(Icon icon, Graphics graphics, int n2, int n3, int n4) {
        this.paintButton(icon, graphics, n2 - icon.getIconWidth() / 2, n3 + 2, n4);
    }

    public void paintButtonLeft(Icon icon, Graphics graphics, int n2, int n3, int n4) {
        this.paintButton(icon, graphics, n2 - icon.getIconWidth() - 2, n3 - icon.getIconHeight() / 2, n4);
    }

    public void paintButtonRight(Icon icon, Graphics graphics, int n2, int n3, int n4) {
        this.paintButton(icon, graphics, n2 + 2, n3 - icon.getIconHeight() / 2, n4);
    }

    public void paintButton(Icon object, Graphics graphics, int n2, int n3, int n4) {
        int n5 = object.getIconWidth() + 4;
        int n6 = object.getIconHeight() + 4;
        if (n4 == this.pressedButton) {
            graphics.setColor(PRESSED_COLOR);
            graphics.fillRect(n2 - 2, n3 - 2, n5, n6);
        }
        object.paintIcon(null, graphics, n2, n3);
        graphics.translate(n2 - 2, n3 - 2);
        object = Globals.getPrefs().handleColorFor(this.getContent());
        graphics.setColor(((Color)object).darker());
        graphics.drawRect(0, 0, n5 - 2, n6 - 2);
        graphics.setColor(((Color)object).brighter().brighter().brighter());
        if (n4 != this.pressedButton) {
            graphics.drawLine(1, n6 - 3, 1, 1);
            graphics.drawLine(1, 1, n5 - 3, 1);
        }
        graphics.drawLine(0, n6 - 1, n5 - 1, n6 - 1);
        graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, 0);
        graphics.translate(-n2 + 2, -n3 + 2);
    }

    @Override
    public Rectangle getBounds() {
        Fig fig = this.getContent();
        return new Rectangle(fig.getX() - 44, fig.getY() - 44, fig.getWidth() + 88, fig.getHeight() + 88);
    }

    public void hideButtons() {
        this.paintButtons = false;
    }

    public void buttonClicked(int n2) {
        Object object;
        Editor editor;
        Serializable serializable;
        Fig fig = this.getContent();
        if (n2 >= 10) {
            ++numButtonClicks;
        }
        Object object2 = null;
        if (n2 != 14) {
            object2 = this.getNewNode(n2);
        }
        if (!((serializable = (editor = Globals.curEditor()).getGraphModel()) instanceof MutableGraphModel)) {
            return;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)serializable;
        if (n2 != 14 && !mutableGraphModel.canAddNode(object2)) {
            return;
        }
        Serializable serializable2 = editor.getGraphNodeRenderer();
        LayerPerspective layerPerspective = (LayerPerspective)editor.getLayerManager().getActiveLayer();
        Fig fig2 = null;
        if (n2 != 14) {
            fig2 = serializable2.getFigNodeFor((GraphModel)serializable, layerPerspective, object2, null);
        }
        serializable = new Rectangle(Math.max(0, fig.getX() - 200), Math.max(0, fig.getY() - 200), fig.getWidth() + 400, fig.getHeight() + 400);
        if (n2 >= 10 && n2 <= 13) {
            int n3 = 0;
            int n4 = 0;
            if (n2 == 10) {
                n3 = fig.getX();
                n4 = Math.max(0, fig.getY() - 200);
            } else if (n2 == 11) {
                n3 = fig.getX();
                n4 = fig.getY() + fig.getHeight() + 100;
            } else if (n2 == 12) {
                n3 = Math.max(0, fig.getX() - 200);
                n4 = fig.getY();
            } else if (n2 == 13) {
                n3 = fig.getX() + fig.getWidth() + 100;
                n4 = fig.getY();
            }
            if (!this.placeFig(fig2, layerPerspective, n3, n4, (Rectangle)serializable)) {
                return;
            }
        }
        if (n2 != 14) {
            editor.add(fig2);
            mutableGraphModel.addNode(object2);
        }
        serializable2 = new FigPoly();
        if (n2 != 14) {
            object = fig.getCenter();
            ((FigPoly)serializable2).addPoint(((Point)object).x, ((Point)object).y);
            serializable = fig2.getCenter();
            ((FigPoly)serializable2).addPoint(((Point)serializable).x, ((Point)serializable).y);
        } else {
            fig2 = fig;
            object = fig.getCenter();
            serializable = new Point((int)((double)((Point)object).x + fig.getSize().getWidth() / 2.0), ((Point)object).y);
            int n5 = (int)(fig.getSize().getHeight() / 2.0);
            ((FigPoly)serializable2).addPoint(((Point)object).x, ((Point)object).y);
            ((FigPoly)serializable2).addPoint(((Point)serializable).x, ((Point)serializable).y);
            ((FigPoly)serializable2).addPoint(((Point)serializable).x + 30, ((Point)serializable).y);
            ((FigPoly)serializable2).addPoint(((Point)serializable).x + 30, ((Point)serializable).y + n5);
            ((FigPoly)serializable2).addPoint(((Point)serializable).x, ((Point)serializable).y + n5);
        }
        object = null;
        if (n2 == 10) {
            object = this.createEdgeAbove(mutableGraphModel, object2);
        } else if (n2 == 11) {
            object = this.createEdgeUnder(mutableGraphModel, object2);
        } else if (n2 == 12) {
            object = this.createEdgeLeft(mutableGraphModel, object2);
        } else if (n2 == 13) {
            object = this.createEdgeRight(mutableGraphModel, object2);
        } else if (n2 == 14) {
            object = this.createEdgeToSelf(mutableGraphModel);
        }
        serializable = (FigEdge)layerPerspective.presentationFor(object);
        ((FigEdge)serializable).setBetweenNearestPoints(true);
        ((Fig)serializable2).setLineColor(Color.black);
        ((Fig)serializable2).setFilled(false);
        ((FigPoly)serializable2).setComplete(true);
        ((FigEdge)serializable).setFig((Fig)serializable2);
        if (n2 != 14) {
            fig2.damage();
        }
        editor.getSelectionManager().select((Fig)serializable);
        editor.getSelectionManager().select(fig);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Handle handle = new Handle(-1);
        this.hitHandle(mouseEvent.getX(), mouseEvent.getY(), 0, 0, handle);
        this.pressedButton = handle.index;
        Globals.curEditor().damaged(this);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.pressedButton < 10) {
            return;
        }
        Handle handle = new Handle(-1);
        this.hitHandle(mouseEvent.getX(), mouseEvent.getY(), 0, 0, handle);
        if (this.pressedButton == handle.index) {
            SelectionButtons selectionButtons = this;
            selectionButtons.buttonClicked(selectionButtons.pressedButton);
            mouseEvent.consume();
        }
        this.pressedButton = -1;
        Globals.curEditor().damaged(this);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        if (showRapidButtons) {
            this.paintButtons = true;
        }
        Globals.curEditor().damaged(this);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.paintButtons = false;
        Globals.curEditor().damaged(this);
    }

    protected boolean placeFig(Fig fig, LayerPerspective layerPerspective, int n2, int n3, Rectangle rectangle) {
        if (this.placeCounter > 1) {
            return false;
        }
        ++this.placeCounter;
        fig.setLocation(n2, n3);
        layerPerspective.bumpOffOtherNodesIn(fig, rectangle, false, false);
        Fig fig2 = this.getContent();
        if (fig.getX() < 0) {
            return this.placeFig(fig, layerPerspective, fig2.getX() + fig2.getWidth() + fig.getWidth() + 100, fig.getY(), rectangle);
        }
        if (fig.getX() + fig.getWidth() >= 6000) {
            return this.placeFig(fig, layerPerspective, fig2.getX() - fig.getWidth() - 100, fig.getY(), rectangle);
        }
        if (fig.getY() + fig.getHeight() >= 6000) {
            return this.placeFig(fig, layerPerspective, fig.getX(), fig2.getY() - fig.getHeight() - 100, rectangle);
        }
        if (fig.getY() < 0) {
            return this.placeFig(fig, layerPerspective, fig.getX(), fig2.getY() + fig2.getHeight() + fig.getHeight() + 100, rectangle);
        }
        return true;
    }

    protected abstract Object getNewNode(int var1);

    protected Object createEdgeAbove(MutableGraphModel mutableGraphModel, Object object) {
        return null;
    }

    protected Object createEdgeLeft(MutableGraphModel mutableGraphModel, Object object) {
        return null;
    }

    protected Object createEdgeRight(MutableGraphModel mutableGraphModel, Object object) {
        return null;
    }

    protected Object createEdgeUnder(MutableGraphModel mutableGraphModel, Object object) {
        return null;
    }

    protected Object createEdgeToSelf(MutableGraphModel mutableGraphModel) {
        return null;
    }

    protected void setPaintButtons(boolean bl2) {
        this.paintButtons = bl2;
    }

    protected boolean isPaintButtons() {
        return this.paintButtons;
    }

    protected void setPressedButton(int n2) {
        this.pressedButton = n2;
    }

    protected int getPressedButton() {
        return this.pressedButton;
    }
}

