/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionReshape$1FigEdgeReshapeMemento;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.undo.UndoManager;

public class SelectionReshape
extends Selection
implements KeyListener {
    private static final long serialVersionUID = 2204649413528863935L;
    private int selectedHandle = -1;

    public SelectionReshape(Fig fig) {
        super(fig);
    }

    @Override
    public void hitHandle(Rectangle rectangle, Handle handle) {
        int n2;
        Fig fig = this.getContent();
        int n3 = fig.getNumPoints();
        int[] nArray = fig.getXs();
        int[] nArray2 = fig.getYs();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!rectangle.contains(nArray[n2], nArray2[n2])) continue;
            this.selectedHandle = n2;
            handle.index = n2;
            handle.instructions = "Move point";
            return;
        }
        if (fig instanceof FigEdgePoly) {
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if (!Geometry.intersects(rectangle, nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1])) continue;
                handle.index = fig.getNumPoints();
                handle.instructions = "Add a point";
                return;
            }
        }
        this.selectedHandle = -1;
        handle.index = -1;
        handle.instructions = "Move object(s)";
    }

    @Override
    public void paint(Graphics graphics) {
        Fig fig = this.getContent();
        int n2 = fig.getNumPoints();
        int[] nArray = fig.getXs();
        int[] nArray2 = fig.getYs();
        graphics.setColor(Globals.getPrefs().handleColorFor(fig));
        for (int i2 = 0; i2 < n2; ++i2) {
            graphics.fillRect(nArray[i2] - 3, nArray2[i2] - 3, 6, 6);
        }
        if (this.selectedHandle != -1) {
            graphics.drawRect(nArray[this.selectedHandle] - 3 - 2, nArray2[this.selectedHandle] - 3 - 2, 9, 9);
        }
    }

    @Override
    public void dragHandle(int n2, int n3, int n4, int n5, Handle handle) {
        Fig fig;
        Fig fig2 = this.getContent();
        if (fig2 instanceof FigEdgePoly) {
            fig = (FigEdgePoly)fig2;
            if (UndoManager.getInstance().isGenerateMementos()) {
                SelectionReshape$1FigEdgeReshapeMemento selectionReshape$1FigEdgeReshapeMemento = new SelectionReshape$1FigEdgeReshapeMemento(this, ((FigEdgePoly)fig).getPolygon(), (FigEdgePoly)fig);
                UndoManager.getInstance().startChain();
                UndoManager.getInstance().addMemento(selectionReshape$1FigEdgeReshapeMemento);
            }
            int n6 = fig2.getNumPoints();
            int[] nArray = fig2.getXs();
            int[] nArray2 = fig2.getYs();
            Rectangle rectangle = new Rectangle(n4 - 4, n5 - 4, 8, 8);
            if (handle.index == ((FigEdge)fig).getNumPoints()) {
                for (n5 = 0; n5 < n6 - 1; ++n5) {
                    if (!Geometry.intersects(rectangle, nArray[n5], nArray2[n5], nArray[n5 + 1], nArray2[n5 + 1])) continue;
                    ((FigEdgePoly)fig).insertPoint(n5, rectangle.x, rectangle.y);
                    handle.index = n5 + 1;
                    break;
                }
            }
            if (handle.index < 0 || handle.index >= ((FigEdge)fig).getNumPoints()) {
                System.out.println("mistake " + handle.index);
            }
            if (handle.index == 0 || handle.index == ((FigEdge)fig).getNumPoints() - 1) {
                this.updateEdgeEnds((FigEdge)fig, handle, n2, n3);
            }
        }
        if (fig2 instanceof FigPoly) {
            fig = (FigPoly)fig2;
            if (handle.index == 0 || handle.index == ((FigPoly)fig).getNumPoints() - 1) {
                Point point;
                Point point2 = point = new Point(n2, n3);
                ((FigPoly)fig).setEndPoints(point2, point2);
                return;
            }
            ((FigPoly)fig).moveVertex(handle, n2, n3, false);
            return;
        }
        fig2.setPoint(handle, n2, n3);
    }

    public void updateEdgeEnds(FigEdge figEdge, Handle handle, int n2, int n3) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getContent() instanceof KeyListener) {
            ((KeyListener)((Object)this.getContent())).keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.getContent() instanceof KeyListener) {
            ((KeyListener)((Object)this.getContent())).keyReleased(keyEvent);
        }
    }
}

