/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;

public class SelectionResize
extends Selection {
    private static final long serialVersionUID = 1996301098909656022L;
    private int cx;
    private int cy;
    private int cw;
    private int ch;
    private static Log log = LogFactory.getLog(SelectionResize.class);

    public SelectionResize(Fig fig) {
        super(fig);
    }

    @Override
    public void hitHandle(Rectangle rectangle, Handle handle) {
        if (this.getContent().isResizable()) {
            this.updateHandleBox();
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            rectangle2.setBounds(this.cx - 3, this.cy - 3, 6, this.ch + 3);
            boolean bl2 = rectangle.intersects(rectangle2);
            rectangle2.setBounds(this.cx + this.cw - 3, this.cy - 3, 6, this.ch + 3);
            boolean bl3 = rectangle.intersects(rectangle2);
            rectangle2.setBounds(this.cx - 3, this.cy - 3, this.cw + 3, 6);
            boolean bl4 = rectangle.intersects(rectangle2);
            rectangle2.setBounds(this.cx - 3, this.cy + this.ch - 3, this.cw + 3, 6);
            boolean bl5 = rectangle.intersects(rectangle2);
            if (bl2 && bl4) {
                handle.index = 0;
                handle.instructions = "Resize top left";
                return;
            }
            if (bl3 && bl4) {
                handle.index = 2;
                handle.instructions = "Resize top right";
                return;
            }
            if (bl2 && bl5) {
                handle.index = 5;
                handle.instructions = "Resize bottom left";
                return;
            }
            if (bl3 && bl5) {
                handle.index = 7;
                handle.instructions = "Resize bottom right";
                return;
            }
            handle.index = -1;
            handle.instructions = "Move object(s)";
            return;
        }
        handle.index = -1;
        handle.instructions = "Move object(s)";
    }

    private void updateHandleBox() {
        Rectangle rectangle = this.getContent().getHandleBox();
        this.cx = rectangle.x;
        this.cy = rectangle.y;
        this.cw = rectangle.width;
        this.ch = rectangle.height;
    }

    @Override
    public void paint(Graphics graphics) {
        Fig fig = this.getContent();
        if (this.getContent().isResizable()) {
            this.updateHandleBox();
            graphics.setColor(Globals.getPrefs().handleColorFor(fig));
            graphics.fillRect(this.cx - 3, this.cy - 3, 6, 6);
            graphics.fillRect(this.cx + this.cw - 3, this.cy - 3, 6, 6);
            graphics.fillRect(this.cx - 3, this.cy + this.ch - 3, 6, 6);
            graphics.fillRect(this.cx + this.cw - 3, this.cy + this.ch - 3, 6, 6);
            return;
        }
        int n2 = fig.getX();
        int n3 = fig.getY();
        int n4 = fig.getWidth();
        int n5 = fig.getHeight();
        graphics.setColor(Globals.getPrefs().handleColorFor(fig));
        graphics.drawRect(n2 - 4, n3 - 4, n4 + 8 - 1, n5 + 8 - 1);
        graphics.drawRect(n2 - 4 - 1, n3 - 4 - 1, n4 + 8 + 2 - 1, n5 + 8 + 2 - 1);
        graphics.fillRect(n2 - 6, n3 - 6, 6, 6);
        graphics.fillRect(n2 + n4, n3 - 6, 6, 6);
        graphics.fillRect(n2 - 6, n3 + n5, 6, 6);
        graphics.fillRect(n2 + n4, n3 + n5, 6, 6);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dragHandle(int n2, int n3, int n4, int n5, Handle handle) {
        void var5_18;
        Fig fig = this.getContent();
        if (!fig.isResizable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Handle " + var5_18 + " dragged but no action as fig is not resizable"));
            }
            return;
        }
        this.updateHandleBox();
        int n6 = this.cx;
        int n7 = this.cy;
        int n8 = this.cw;
        int n9 = this.ch;
        Dimension dimension = fig.getMinimumSize();
        int n10 = dimension.width;
        int n11 = dimension.height;
        switch (var5_18.index) {
            case -1: {
                int n12;
                fig.translate(n4 - n2, (int)(n12 - n3));
                return;
            }
            case 0: {
                int n13 = n6 + n8 - n2;
                n13 = n13 < n10 ? n10 : n13;
                int n12 = n7 + n9 - n3;
                n12 = n12 < n11 ? n11 : n12;
                n2 = n6 + n8 - n13;
                n3 = n7 + n9 - n12;
                fig.setHandleBox(n2, n3, n13, n12);
                if (n2 + n13 != n6 + n8) {
                    int n14 = n2;
                    n2 = n14 + (n14 + n13 - (n6 + n8));
                }
                if (n3 + n12 != n7 + n9) {
                    int n15 = n3;
                    n3 = n15 + (n15 + n12 - (n7 + n9));
                }
                fig.setHandleBox(n2, n3, n13, n12);
                return;
            }
            case 1: {
                break;
            }
            case 2: {
                int n17 = n2 - n6;
                n17 = n17 < n10 ? n10 : n17;
                int n12 = n7 + n9 - n3;
                n12 = n12 < n11 ? n11 : n12;
                n3 = n7 + n9 - n12;
                fig.setHandleBox(n6, n3, n17, n12);
                if (n3 + n12 != n7 + n9) {
                    int n18 = n3;
                    n3 = n18 + (n18 + n12 - (n7 + n9));
                }
                fig.setHandleBox(n6, n3, n17, n12);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int n20 = n6 + n8 - n2;
                n20 = n20 < n10 ? n10 : n20;
                int n12 = n3 - n7;
                n12 = n12 < n11 ? n11 : n12;
                n2 = n6 + n8 - n20;
                fig.setHandleBox(n2, n7, n20, n12);
                if (n2 + n20 != n6 + n8) {
                    int n21 = n2;
                    n2 = n21 + (n21 + n20 - (n6 + n8));
                }
                fig.setHandleBox(n2, n7, n20, n12);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                int n23 = n2 - n6;
                n23 = n23 < n10 ? n10 : n23;
                int n12 = n3 - n7;
                n12 = n12 < n11 ? n11 : n12;
                fig.setHandleBox(n6, n7, n23, n12);
                break;
            }
            default: {
                log.error((Object)"invalid handle number for resizing fig");
                return;
            }
        }
        if (fig instanceof FigNode) {
            FigNode figNode = (FigNode)fig;
            for (Fig fig2 : figNode.getConnectors()) {
                Point point = new Point(fig2.getX() + fig2.getHalfWidth(), fig2.getY() + fig2.getHalfHeight());
                point = figNode.getClosestPoint(point);
                fig2.setLocation(point.x - fig2.getHalfWidth(), point.y - fig2.getHalfHeight());
            }
        }
    }
}

