/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;

public class OCLEvaluator {
    public static String OCL_START = "<ocl>";
    public static String OCL_END = "</ocl>";
    public static String GET_NAME_EXPR_1 = "self";
    public static String GET_NAME_EXPR_2 = "self.name.body";
    public static String GET_OWNER_EXPR = "self.owner";
    private static final Log LOG = LogFactory.getLog(OCLEvaluator.class);
    protected Map _scratchBindings = new Hashtable();
    protected StringBuffer _strBuf = new StringBuffer(100);

    protected OCLEvaluator() {
    }

    protected synchronized String evalToString(Object object, String string) {
        return this.evalToString(object, string, ", ");
    }

    protected synchronized String evalToString(Object iterator, String string, String string2) {
        this._scratchBindings.put("self", iterator);
        OCLEvaluator oCLEvaluator = this;
        iterator = oCLEvaluator.eval(oCLEvaluator._scratchBindings, string);
        this._strBuf.setLength(0);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            if (string.length() <= 0) continue;
            this._strBuf.append(string);
            if (!iterator.hasNext()) continue;
            this._strBuf.append(string2);
        }
        return this._strBuf.toString();
    }

    protected List eval(Map map, String string) {
        Vector vector;
        Object v2;
        int n2 = string.indexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((v2 = map.get(string.substring(0, n2))) instanceof Vector) {
            vector = (Vector)v2;
        } else {
            vector = new Vector();
            vector.addElement(v2);
        }
        if (string.equals("self")) {
            return vector;
        }
        string = string.substring(n2);
        return this.eval(map, string, vector);
    }

    private List eval(Map object, String string, List vector) {
        object = string;
        try {
            while (((String)object).length() > 0) {
                String string2;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = ((String)object).indexOf(".");
                int n3 = ((String)object).indexOf(".", n2 + 1);
                if (n3 == -1) {
                    string2 = ((String)object).substring(n2 + 1);
                    object = "";
                } else {
                    string2 = ((String)object).substring(n2 + 1, n3);
                    object = ((String)object).substring(n3);
                }
                n3 = vector.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    arrayList.add(this.evaluateProperty(vector.get(i2), string2));
                }
                vector = new Vector(this.flatten(arrayList));
            }
        }
        catch (Exception exception) {
            throw new ExpansionException("Exception while expanding the expression " + string + " (" + (String)object + ")", exception);
        }
        return vector;
    }

    private String toTitleCase(String string) {
        if (string.length() > 0) {
            return this.toUpperCase(string.charAt(0)) + string.substring(1, string.length());
        }
        return string;
    }

    private char toUpperCase(char c2) {
        int n2 = "abcdefghijklmnopqrstuvwxyz".indexOf(c2);
        if (n2 == -1) {
            return c2;
        }
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n2);
    }

    private Object evaluateProperty(Object object, String string) {
        Method method;
        if (object == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for property '" + string + "' on " + object.getClass().getName()));
        }
        String string2 = null;
        int n2 = string.indexOf(91);
        if (n2 >= 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        if ((method = this.getMethod(object.getClass(), "get" + this.toTitleCase(string))) != null) {
            return this.invokeMethod(method, object, string2);
        }
        method = this.getMethod(object.getClass(), string);
        if (method != null) {
            return this.invokeMethod(method, object, string2);
        }
        method = this.getMethod(object.getClass(), this.toTitleCase(string));
        if (method != null) {
            LOG.warn((Object)("Reference to a method with bad naming convention - " + this.toTitleCase(string)));
            return this.invokeMethod(method, object, string2);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for variable '" + string + "'"));
        }
        try {
            return OCLEvaluator.convertCollection(object.getClass().getField(string).get(object), string2);
        }
        catch (Exception exception) {
            LOG.error((Object)("Failed to get field " + string + " on " + object.getClass().getName()), (Throwable)exception);
            return null;
        }
    }

    private Object invokeMethod(Method method, Object object, String string) {
        method.setAccessible(true);
        if (method != null) {
            try {
                return OCLEvaluator.convertCollection(method.invoke(object, null), string);
            }
            catch (Exception exception) {
                throw new ExpansionException(exception);
            }
        }
        return null;
    }

    private List flatten(List list) {
        ArrayList arrayList = new ArrayList();
        this.flattenInto(list, arrayList);
        return arrayList;
    }

    private void flattenInto(Object iterator, List list) {
        if (iterator instanceof List) {
            for (Object e2 : (List)((Object)iterator)) {
                this.flattenInto(e2, list);
            }
            return;
        }
        list.add(iterator);
    }

    private static Object convertCollection(Object list, String object) {
        if (!(list instanceof Collection) && !(list instanceof Object[])) {
            return list;
        }
        if (list instanceof Object[]) {
            list = Arrays.asList((Object[])list);
        } else if (!(list instanceof List)) {
            list = new ArrayList<Object>((Collection)list);
        }
        if (object != null) {
            object = new StringTokenizer((String)object, "[,]");
            int n2 = OCLEvaluator.getValue(((StringTokenizer)object).nextToken(), list);
            int n3 = OCLEvaluator.getValue(((StringTokenizer)object).nextToken(), list);
            if (n3 <= n2) {
                return Collections.EMPTY_LIST;
            }
            list = list.subList(n2, n3);
        }
        return list;
    }

    private static final int getValue(String string, List list) {
        if (string.trim().equals("*")) {
            return list.size();
        }
        return Integer.parseInt(string);
    }

    private Method getMethod(Class methodArray, String string) {
        methodArray = methodArray.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if (methodArray[i2].getParameterTypes().length != 0 || !methodArray[i2].getName().equals(string)) continue;
            return methodArray[i2];
        }
        return null;
    }
}

