/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ocl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.ocl.ExpansionException;
import org.tigris.gef.ocl.MethodInfo;
import org.tigris.gef.ocl.OCLEvaluator;
import org.tigris.gef.ocl.TemplateRecord;

public class OCLExpander {
    public static String OCL_START = "<ocl";
    public static String OCL_END = "</ocl>";
    public Map _templates = new Hashtable();
    public Hashtable _bindings = new Hashtable();
    public boolean _useXMLEscapes = true;
    protected OCLEvaluator evaluator;
    private static final Log LOG = LogFactory.getLog(OCLExpander.class);

    public OCLExpander(Map map) {
        this._templates = map;
        this.createEvaluator();
    }

    protected void createEvaluator() {
        this.evaluator = new OCLEvaluator();
    }

    public void expand(OutputStream outputStream, Object object) {
        this.expandContent(new PrintWriter(outputStream), object, "", "");
    }

    private void expand(OutputStream outputStream, Object object, String string, String string2) {
        this.expandContent(new PrintWriter(outputStream), object, string, string2);
    }

    public void expand(Writer writer, Object object) {
        this.expand(writer, object, "", "");
    }

    public void expand(Writer writer, Object object, String string) {
        this.expand(writer, object, string, "");
    }

    private void expand(Writer writer, Object object, String string, String string2) {
        writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.expandContent((PrintWriter)writer, object, string, string2);
    }

    private void expandContent(PrintWriter printWriter, Object object, String string, String string2) {
        Object object2;
        Object object3;
        if (object == null) {
            return;
        }
        List list = this.findTemplatesFor(object);
        String string3 = null;
        int n2 = list == null ? 0 : list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            object3 = (TemplateRecord)list.get(i2);
            if (((TemplateRecord)object3).getGuard() == null || ((TemplateRecord)object3).getGuard().equals("")) {
                string3 = ((TemplateRecord)object3).body;
                break;
            }
            this._bindings.put("self", object);
            OCLExpander oCLExpander = this;
            object2 = oCLExpander.evaluate(oCLExpander._bindings, ((TemplateRecord)object3).getGuard());
            if (object2.size() <= 0 || Boolean.FALSE.equals(object2.get(0))) continue;
            string3 = ((TemplateRecord)object3).body;
            break;
        }
        if (string3 == null) {
            printWriter.print(string);
            String string4 = object.toString();
            if (object instanceof MethodInfo) {
                object3 = (MethodInfo)object;
                Object[] objectArray = new Object[2];
                object2 = objectArray;
                objectArray[0] = printWriter;
                object2[1] = new Integer(string.length());
                try {
                    ((MethodInfo)object3).getMethod().invoke(((MethodInfo)object3).getObject(), (Object[])object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ExpansionException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ExpansionException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ExpansionException(invocationTargetException);
                }
            } else {
                if (this._useXMLEscapes) {
                    string4 = this.replaceWithXMLEscapes(string4);
                }
                printWriter.print(string4);
            }
            printWriter.println(string2);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n\r");
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            this.expandLine(printWriter, (String)object2, object, string, string2, ++n3);
        }
    }

    private void expandLine(PrintWriter printWriter, String object, Object object2, String string, String string2, int n2) {
        int n3 = ((String)object).indexOf(OCL_START, 0);
        int n4 = ((String)object).indexOf(OCL_END, 0);
        if (n3 == -1 || n4 == -1) {
            printWriter.println(string + (String)object + string2);
            return;
        }
        if (((String)object).indexOf(OCL_START, n4) >= 0) {
            while (n3 >= 0) {
                int n5 = ((String)object).indexOf(62, n3) + 1;
                boolean bl2 = this.isIgnoreNull(((String)object).substring(n3 + 4, n5));
                String string3 = ((String)object).substring(0, n3);
                String string4 = ((String)object).substring(n5, n4);
                object = ((String)object).substring(n4 + OCL_END.length());
                this._bindings.put("self", object2);
                if (object2 == null) {
                    throw new ExpansionException("Target is null when evaluating the expression '" + string4 + "' at line " + n2);
                }
                OCLExpander oCLExpander = this;
                Iterator iterator = oCLExpander.evaluate(oCLExpander._bindings, string4).iterator();
                StringWriter stringWriter = new StringWriter();
                if (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (e2 == null && !bl2) {
                        throw new ExpansionException("Evaluated the expression '" + string4 + "' to null on object of class " + object2.getClass().getName() + " at line " + n2);
                    }
                    this.expand(stringWriter, e2, string3, (String)object);
                }
                if (iterator.hasNext()) {
                    throw new IllegalStateException("A repeating expression cannot be on the same line as any other expression.");
                }
                object = stringWriter.toString();
                while (((String)object).endsWith("\n") || ((String)object).endsWith("\r")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                n3 = ((String)object).indexOf(OCL_START, 0);
                n4 = ((String)object).indexOf(OCL_END, 0);
            }
            printWriter.println(string + (String)object + string2);
            return;
        }
        int n6 = ((String)object).indexOf(62, n3) + 1;
        boolean bl3 = this.isIgnoreNull(((String)object).substring(n3 + 4, n6));
        string = string + ((String)object).substring(0, n3);
        String string5 = ((String)object).substring(n6, n4);
        string2 = ((String)object).substring(n4 + OCL_END.length()) + string2;
        this._bindings.put("self", object2);
        if (object2 == null) {
            throw new ExpansionException("Target is null when evaluating the expression '" + string5 + "' at line " + n2);
        }
        OCLExpander oCLExpander = this;
        for (Object e3 : oCLExpander.evaluate(oCLExpander._bindings, string5)) {
            if (e3 == null && !bl3) {
                throw new ExpansionException("Evaluated the expression '" + string5 + "' to null on object of class " + object2.getClass().getName() + " at line " + n2);
            }
            this.expand(printWriter, e3, string, string2);
        }
    }

    private boolean isIgnoreNull(String string) {
        return string.startsWith(" ignoreNull>");
    }

    private List findTemplatesFor(Object clazz) {
        ArrayList arrayList = null;
        boolean bl2 = true;
        for (clazz = clazz.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ArrayList arrayList2 = (ArrayList)this._templates.get(clazz);
            if (arrayList2 == null) continue;
            if (arrayList == null) {
                arrayList = arrayList2;
                continue;
            }
            if (bl2) {
                bl2 = false;
                ArrayList arrayList3 = new ArrayList();
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    arrayList3.add(arrayList.get(i2));
                }
                arrayList = arrayList3;
            }
            for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                arrayList.add(arrayList2.get(i3));
            }
        }
        return arrayList;
    }

    private String replaceWithXMLEscapes(String string) {
        string = this.replaceAll(string, "&", "&amp;");
        string = this.replaceAll(string, "<", "&lt;");
        string = this.replaceAll(string, ">", "&gt;");
        string = this.replaceAll(string, "\"", "&quot;");
        return this.replaceAll(string, "'", "&apos;");
    }

    private String replaceAll(String string, String string2, String string3) {
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        int n4 = string3.length();
        while (n2 != -1) {
            string = string.substring(0, n2) + string3 + string.substring(n2 + n3);
            n2 = string.indexOf(string2, n2 + n4);
        }
        return string;
    }

    private List evaluate(Map iterator, String object) {
        if ("self".equals(object) || ((String)object).startsWith("self.")) {
            return this.evaluator.eval((Map)((Object)iterator), (String)object);
        }
        int n2 = ((String)object).indexOf(40);
        Object object2 = ((String)object).substring(0, n2);
        int n3 = ((String)object).lastIndexOf(41);
        object = ((String)object).substring(n2 + 1, n3);
        iterator = this.evaluator.eval((Map)((Object)iterator), (String)object);
        object = new ArrayList(iterator.size());
        n2 = ((String)object2).lastIndexOf(46);
        Object object3 = ((String)object2).substring(0, n2);
        String string = ((String)object2).substring(n2 + 1);
        try {
            object2 = Class.forName((String)object3);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                Object object4 = object3 == null ? Object.class : object3.getClass();
                if (!Modifier.isStatic(((Method)(object4 = this.getMethod((Class)object2, (Class)object4, string))).getModifiers())) {
                    throw new ExpansionException("The method " + ((Method)object4).toString() + " was expected to be static");
                }
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = object3;
                object3 = ((Method)object4).invoke(null, objectArray2);
                if (object3 instanceof List) {
                    return (List)object3;
                }
                ((ArrayList)object).add(object3);
            }
        }
        catch (Exception exception) {
            object2 = exception;
            if (exception instanceof ExpansionException) {
                throw (ExpansionException)object2;
            }
            throw new ExpansionException((Throwable)object2);
        }
        return object;
    }

    private Method getMethod(Class clazz, Class clazz2, String string) {
        Class clazz3 = clazz2;
        Method[] methodArray = clazz.getMethods();
        do {
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(string) || methodArray[i2].getParameterTypes().length != 1 || !methodArray[i2].getParameterTypes()[0].equals(clazz3)) continue;
                return methodArray[i2];
            }
        } while ((clazz3 = clazz3.getSuperclass()) != null);
        throw new ExpansionException("Can't find a method " + string + " on " + clazz.getName() + " that takes an object compatible with " + clazz2.getName() + " as the only argument");
    }
}

