/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.persistence.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParserBase
extends DefaultHandler {
    private static final String RETURNSTRING = "\n      ";
    protected static final boolean DBG = false;
    private XMLElement[] elements = new XMLElement[100];
    private int nElements = 0;
    private XMLElement[] freeElements = new XMLElement[100];
    private int nFreeElements = 0;
    private boolean stats = true;
    private long parseTime = 0L;
    private static Log LOG = LogFactory.getLog(SAXParserBase.class);

    public void setStats(boolean bl2) {
        this.stats = bl2;
    }

    public boolean getStats() {
        return this.stats;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void parse(InputStream object) {
        long l2;
        long l3;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            object = new InputSource((InputStream)object);
            ((InputSource)object).setSystemId(this.getJarResource("org.argouml.kernel.Project"));
            l3 = System.currentTimeMillis();
            sAXParser.parse((InputSource)object, (DefaultHandler)this);
            l2 = System.currentTimeMillis();
            this.parseTime = l2 - l3;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        if (this.stats && LOG.isInfoEnabled()) {
            LOG.info((Object)("Elapsed time: " + (l2 - l3) + " ms"));
        }
    }

    protected abstract void handleStartElement(XMLElement var1);

    protected abstract void handleEndElement(XMLElement var1);

    @Override
    public void startElement(String object, String charSequence, String string, Attributes attributes) {
        if (this.isElementOfInterest(string)) {
            object = this.createXmlElement(string, attributes);
            if (LOG.isDebugEnabled()) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("START: ").append(string).append(' ').append(object);
                for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                    ((StringBuffer)charSequence).append("   ATT: ").append(attributes.getLocalName(i2)).append(' ').append(attributes.getValue(i2));
                }
                LOG.debug((Object)((StringBuffer)charSequence).toString());
            }
            this.elements[this.nElements++] = object;
            this.handleStartElement((XMLElement)object);
        }
    }

    private XMLElement createXmlElement(String string, Attributes attributes) {
        if (this.nFreeElements == 0) {
            return new XMLElement(string, attributes);
        }
        XMLElement xMLElement = this.freeElements[--this.nFreeElements];
        xMLElement.setName(string);
        xMLElement.setAttributes(attributes);
        xMLElement.resetText();
        return xMLElement;
    }

    @Override
    public void endElement(String object, String charSequence, String string) {
        if (this.isElementOfInterest(string)) {
            object = this.elements[--this.nElements];
            if (LOG.isDebugEnabled()) {
                charSequence = new StringBuffer();
                ((StringBuffer)charSequence).append("END: " + ((XMLElement)object).getName() + " [" + ((XMLElement)object).getText() + "] " + object + "\n");
                for (int i2 = 0; i2 < ((XMLElement)object).getNumAttributes(); ++i2) {
                    ((StringBuffer)charSequence).append("   ATT: " + ((XMLElement)object).getAttributeName(i2) + " " + ((XMLElement)object).getAttributeValue(i2) + "\n");
                }
                LOG.debug((Object)charSequence);
            }
            this.handleEndElement((XMLElement)object);
        }
    }

    protected boolean isElementOfInterest(String string) {
        return true;
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        for (int i2 = 0; i2 < this.nElements; ++i2) {
            XMLElement xMLElement = this.elements[i2];
            if (xMLElement.getText().length() > 0) {
                xMLElement.addText(RETURNSTRING);
            }
            xMLElement.addText(new String(cArray, n2, n3));
        }
    }

    @Override
    public InputSource resolveEntity(String object, String string) {
        try {
            object = new URL(string);
            return new InputSource(((URL)object).openStream());
        }
        catch (Exception exception) {
            LOG.info((Object)("NOTE: Could not open DTD " + string + " due to exception"));
            String string2 = string;
            Object object2 = string2.substring(string2.lastIndexOf(47) + 1);
            string = "/org/argouml/persistence/".concat(String.valueOf(object2));
            object2 = SAXParserBase.class.getResourceAsStream(string);
            if (object2 == null) {
                try {
                    object2 = new FileInputStream(string.substring(1));
                }
                catch (Exception exception2) {
                    throw new SAXException(exception);
                }
            }
            return new InputSource((InputStream)object2);
        }
    }

    public String getJarResource(String object) {
        String string = "";
        String string2 = System.getProperty("file.separator");
        object = ((String)object).replace('.', string2.charAt(0)) + ".class";
        object = this.getClass().getClassLoader().getResource((String)object);
        if (object != null) {
            object = ((URL)object).getFile();
            int n2 = ((String)object).indexOf("file:");
            int n3 = ((String)object).indexOf("!");
            if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                string = ((String)object).substring(n2 + 5, n3);
            }
        }
        return string;
    }

    public void ignoreElement(XMLElement xMLElement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NOTE: ignoring tag:" + xMLElement.getName()));
        }
    }

    public void notImplemented(XMLElement xMLElement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NOTE: element not implemented: " + xMLElement.getName()));
        }
    }
}

