/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import org.tigris.gef.persistence.export.FontUtility;

public class PostscriptWriter
extends Graphics2D {
    private PrintWriter p;
    private boolean autoClose = false;
    private static final String ellipseDef = "%%BeginProcSet: ellipse 1.0 0 \n/ellipsedict 8 dict def \nellipsedict /mtrx matrix put \n/ellipse { ellipsedict begin \n/endangle exch def \n/startangle exch def \n/yrad exch def \n/xrad exch def \n/y exch def \n/x exch def \n/savematrix mtrx currentmatrix def \nx y translate \nxrad yrad scale \n0 0 1 0 360 arc \nsavematrix setmatrix end } def \n%%EndProcSet: ellipse 1.0 0 \n";
    private static final String reencodeDef = "%%BeginProcSet: reencode 1.0 0 \n/RE \n{  findfont begin \n  currentdict dup length dict begin \n  {1 index /FID ne {def} {pop pop} ifelse} forall \n  /FontName exch def dup length 0 ne \n  { /Encoding Encoding 256 array copy def \n      0 exch \n      { dup type /nametype eq \n        { Encoding 2 index 2 index put \n          pop 1 add \n        } \n        { exch pop \n        } ifelse \n      } forall \n  } if pop \n  currentdict dup end end \n  /FontName get exch definefont pop \n    } bind def \n%%EndProcSet: reencode 1.0 0 \n";
    private static final String isolatin1encoding = "/isolatin1encoding \n[ 32 /space /exclam /quotedbl /numbersign /dollar /percent /ampersand /quoteright \n /parenleft /parenright /asterisk /plus /comma /hyphen /period /slash /zero /one \n /two /three /four /five /six /seven /eight /nine /colon /semicolon \n /less /equal /greater /question /at /A /B /C /D /E \n /F /G /H /I /J /K /L /M /N /O \n /P /Q /R /S /T /U /V /W /X /Y \n /Z /bracketleft /backslash /bracketright /asciicircum /underscore /quoteleft /a /b /c \n /d /e /f /g /h /i /j /k /l /m \n /n /o /p /q /r /s /t /u /v /w \n /x /y /z /braceleft /bar /braceright /asciitilde /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef /.notdef \n /space /exclamdown /cent /sterling /currency /yen /brokenbar /section /dieresis /copyright \n /ordfeminine /guillemotleft /logicalnot /hyphen /registered /macron /degree /plusminus /twosuperior /threesuperior \n /acute /mu /paragraph /periodcentered /cedilla /onesuperior /ordmasculine /guillemotright /onequarter /onehalf \n /threequarters /questiondown /Agrave /Aacute /Acircumflex /Atilde /Adieresis /Aring /AE /Ccedilla \n /Egrave /Eacute /Ecircumflex /Edieresis /Igrave /Iacute /Icircumflex /Idieresis /Eth /Ntilde \n /Ograve /Oacute /Ocircumflex /Otilde /Odieresis /multiply /Oslash /Ugrave /Uacute /Ucircumflex \n /Udieresis /Yacute /Thorn /germandbls /agrave /aacute /acircumflex /atilde /adieresis /aring \n /ae /ccedilla /egrave /eacute /ecircumflex /edieresis /igrave /iacute /icircumflex /idieresis \n /eth /ntilde /ograve /oacute /ocircumflex /otilde /odieresis /divide /oslash /ugrave \n /uacute /ucircumflex /udieresis /yacute /thorn /ydieresis] def \n";
    private Color fColor = null;
    private Font fFont = null;
    private Rectangle clip;
    private Hashtable fontmap = new Hashtable();
    private Hashtable colormap = new Hashtable();
    private BasicStroke stroke = null;
    private String lastStroke = "[] 0 setdash";

    public PostscriptWriter(String string) {
        this(string, null);
    }

    public PostscriptWriter(String string, Rectangle rectangle) {
        this(new FileOutputStream(string), rectangle);
        this.autoClose = true;
    }

    public PostscriptWriter(OutputStream outputStream) {
        this(outputStream, null);
    }

    public PostscriptWriter(OutputStream outputStream, Rectangle rectangle) {
        this.fontmap.put("Dialog", "Helvetica");
        this.fontmap.put("SansSerif", "Helvetica");
        this.fontmap.put("DialogInput", "Monospaced");
        this.p = new PrintWriter(new OutputStreamWriter(outputStream, "ISO8859-1"));
        if (rectangle == null) {
            this.p.println("%!PS-Adobe-3.0");
        } else {
            this.p.println("%!PS-Adobe-3.0 EPSF-3.0");
            this.p.println("%%BoundingBox: " + rectangle.x + " " + rectangle.y + " " + (rectangle.x + rectangle.width) + " " + (rectangle.y + rectangle.height));
        }
        this.p.print(reencodeDef);
        this.p.print(ellipseDef);
        this.p.println("%%EndProlog");
        this.p.println("%%BeginSetup");
        this.p.print(isolatin1encoding);
        this.p.println("%%EndSetup");
        this.p.println("1 setlinewidth");
        this.setFont(new Font("Helvetica", 0, 12));
        this.setColor(Color.black);
        if (rectangle != null) {
            this.translate(0, rectangle.height + 2 * rectangle.y);
        }
    }

    @Override
    public Graphics create() {
        return this;
    }

    @Override
    public Graphics create(int n2, int n3, int n4, int n5) {
        return this;
    }

    @Override
    public void dispose() {
        this.p.println("showpage");
        this.p.println("%%Trailer");
        if (this.autoClose) {
            this.p.close();
            return;
        }
        this.p.flush();
    }

    public void setColorConversion(Color color, Color color2) {
        this.colormap.put(color, color2);
    }

    @Override
    public Color getColor() {
        return this.fColor;
    }

    @Override
    public void setColor(Color color) {
        Color color2 = (Color)this.colormap.get(color);
        if (color2 != null) {
            color = color2;
        }
        if (color.equals(this.fColor)) {
            return;
        }
        this.fColor = color;
        this.p.print((float)color.getRed() / 255.0f + " ");
        this.p.print((float)color.getGreen() / 255.0f + " ");
        this.p.print((float)color.getBlue() / 255.0f + " ");
        this.p.println("setrgbcolor");
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public Font getFont() {
        return this.fFont;
    }

    @Override
    public void setFont(Font font) {
        if (!font.equals(this.fFont)) {
            this.fFont = font;
            this.getFontMetrics();
            String string = font.getName();
            if (this.fontmap.containsKey(string)) {
                string = (String)this.fontmap.get(string);
            }
            if (font.isBold() || font.isItalic()) {
                string = string + "-";
                if (font.isBold()) {
                    string = string + "Bold";
                }
                if (font.isItalic()) {
                    string = string + "Oblique";
                }
            }
            this.p.println("isolatin1encoding /_" + string + " /" + string + " RE");
            this.p.println("/_" + string + " findfont");
            this.p.println(font.getSize() + " scalefont setfont");
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        PostscriptWriter postscriptWriter = this;
        return postscriptWriter.getFontMetrics(postscriptWriter.fFont);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontUtility.getFontMetrics(font);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip;
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
        this.setClip(n2, n3, n4, n5);
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return false;
    }

    private void handlesinglepixel(int n2, int n3, int n4) {
        if (n4 >>> 24 == 0) {
            n4 = 0xFFFFFF;
        }
        this.p.print(Integer.toHexString(n4 >> 20 & 0xF) + Integer.toHexString(n4 >> 12 & 0xF) + Integer.toHexString(n4 >> 4 & 0xF));
    }

    @Override
    public boolean drawImage(Image object, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        int n6;
        int n7 = ((Image)object).getWidth(imageObserver);
        int n8 = ((Image)object).getHeight(imageObserver);
        this.p.println("gsave");
        this.writeCoords(n2, n3 + n5);
        this.p.println("translate");
        this.writeCoords(n4, -n5);
        this.p.println("scale");
        this.p.println("/DatenString " + n7 + " string def");
        this.writeCoords(n7, -n8);
        this.p.println("4 [" + n7 + " 0 0 " + -n8 + " 0 " + n8 + "]");
        this.p.println("{currentfile DatenString readhexstring pop} bind");
        this.p.println("false 3 colorimage");
        int[] nArray = new int[n7 * n8];
        object = new PixelGrabber((Image)object, 0, 0, n7, n8, nArray, 0, n7);
        try {
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((((PixelGrabber)object).getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        for (n6 = 0; n6 < n8; ++n6) {
            for (n3 = 0; n3 < n7; ++n3) {
                this.handlesinglepixel(n3, n6, nArray[n6 * n7 + n3]);
            }
            if (n7 % 2 == 1) {
                this.p.print("0");
            }
            this.p.println();
        }
        if (n8 % 2 == 1) {
            n6 = 0;
            while (true) {
                int n9 = n7;
                if (n6 >= 3 * (n9 + n9 % 2)) break;
                this.p.print("0");
                ++n6;
            }
            this.p.println();
        }
        this.p.println("grestore");
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        return false;
    }

    private void writeSetDash() {
        float[] fArray;
        CharSequence charSequence = "[] 0 setdash";
        if (this.stroke != null && (fArray = this.stroke.getDashArray()) != null) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append('[');
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                ((StringBuffer)charSequence).append(fArray[i2]).append(' ');
            }
            ((StringBuffer)charSequence).append("] 0 setdash");
            charSequence = ((StringBuffer)charSequence).toString();
        }
        if (!this.lastStroke.equals(charSequence)) {
            this.lastStroke = charSequence;
            this.p.println((String)charSequence);
        }
    }

    private void writeCoords(int n2, int n3) {
        this.p.print(n2 + " " + -n3 + " ");
    }

    private void writeRectanglePath(int n2, int n3, int n4, int n5) {
        this.p.println("newpath");
        this.writeCoords(n2, n3);
        this.p.println("moveto");
        this.writeCoords(n4 - 1, 0);
        this.p.println("rlineto");
        this.writeCoords(0, n5 - 1);
        this.p.println("rlineto");
        this.writeCoords(-(n4 - 1), 0);
        this.p.println("rlineto");
        this.p.println("closepath");
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        this.writeRectanglePath(n2, n3, n4 + 1, n5 + 1);
        this.p.println("stroke");
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.writeRectanglePath(n2, n3, n4, n5);
        this.p.println("eofill");
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
        this.writeRectanglePath(n2, n3, n4, n5);
        this.setColor(Color.white);
        this.p.println("eofill");
    }

    private void writeEllipsePath(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeSetDash();
        this.p.println("newpath");
        this.writeCoords(n2 + (n4 /= 2), n3 + (n5 /= 2));
        this.writeCoords(n4, n5);
        int n8 = n6;
        this.writeCoords(n8, -(n8 + n7));
        this.p.println("ellipse");
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        this.writeEllipsePath(n2, n3, n4 + 1, n5 + 1, 0, 360);
        this.p.println("stroke");
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        this.writeEllipsePath(n2, n3, n4, n5, 0, 360);
        this.p.println("eofill");
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeEllipsePath(n2, n3, n4 + 1, n5 + 1, n6, n7);
        this.p.println("stroke");
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeEllipsePath(n2, n3, n4, n5, n6, n7);
        this.p.println("eofill");
    }

    private void writeRoundRectPath(int n2, int n3, int n4, int n5, int n6, int n7) {
        String string = Math.min(n6, n7) + " arcto 4 {pop} repeat";
        this.writeSetDash();
        this.p.println("newpath");
        this.writeCoords(n2, n3 + n7);
        this.p.println("moveto");
        this.writeCoords(n2, n3);
        this.writeCoords(n2 + n6, n3);
        this.p.println(string);
        this.writeCoords(n2 + n4, n3);
        this.writeCoords(n2 + n4, n3 + n7);
        this.p.println(string);
        this.writeCoords(n2 + n4, n3 + n5);
        this.writeCoords(n2 + n4 - n6, n3 + n5);
        this.p.println(string);
        this.writeCoords(n2, n3 + n5);
        this.writeCoords(n2, n3 + n5 - n7);
        this.p.println(string);
        this.p.println("closepath");
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeRoundRectPath(n2, n3, n4 + 1, n5 + 1, n6, n7);
        this.p.println("stroke");
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.writeRoundRectPath(n2, n3, n4, n5, n6, n7);
        this.p.println("eofill");
    }

    private void writePolyLinePath(int[] nArray, int[] nArray2, int n2) {
        this.writeSetDash();
        this.p.println("newpath");
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeCoords(nArray[i2], nArray2[i2]);
            if (i2 == 0) {
                this.p.println("moveto");
                continue;
            }
            this.p.println("lineto");
        }
    }

    public void writePolygonPath(int[] nArray, int[] nArray2, int n2) {
        this.writePolyLinePath(nArray, nArray2, n2);
        this.p.println("closepath");
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.writePolygonPath(nArray, nArray2, n2);
        this.p.println("stroke");
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.writePolygonPath(nArray, nArray2, n2);
        this.p.println("eofill");
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        this.writePolyLinePath(nArray, nArray2, n2);
        this.p.println("stroke");
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        this.writeSetDash();
        this.p.println("newpath");
        this.writeCoords(n2, n3);
        this.p.println("moveto");
        this.writeCoords(n4, n5);
        this.p.println("lineto");
        this.p.println("stroke");
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this.clip = new Rectangle(n2, n3, n4, n5);
        this.writeRectanglePath(n2, n3, n4, n5);
        this.p.println("clip");
    }

    @Override
    public void setClip(Shape shape) {
        this.setClip(shape.getBounds());
    }

    @Override
    public void translate(int n2, int n3) {
        this.writeCoords(n2, -n3);
        this.p.println("translate");
    }

    @Override
    public void scale(double d2, double d3) {
        this.p.println(d2 + " " + d3 + " scale");
    }

    @Override
    public void drawString(String charSequence, int n2, int n3) {
        charSequence = new StringBuffer((String)charSequence);
        for (int i2 = 0; i2 < ((StringBuffer)charSequence).length(); ++i2) {
            char c2 = ((StringBuffer)charSequence).charAt(i2);
            if (c2 >= '\u00c0' && c2 < '\u0100') {
                ((StringBuffer)charSequence).setCharAt(i2, '\\');
                String string = Integer.toOctalString(c2);
                ((StringBuffer)charSequence).insert(i2 + 1, string);
                i2 += string.length();
                continue;
            }
            if (c2 != '\\' && c2 != '(' && c2 != ')') continue;
            ((StringBuffer)charSequence).insert(i2++, '\\');
        }
        this.writeCoords(n2, n3);
        this.p.println("moveto");
        this.p.println("(" + ((StringBuffer)charSequence).toString() + ") show");
    }

    public void comment(String string) {
        this.p.println("% ".concat(String.valueOf(string)));
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        throw new RuntimeException("Not supported.");
    }

    public void addRenderingHints(Map map) {
    }

    @Override
    public void clip(Shape shape) {
    }

    @Override
    public void draw(Shape shape) {
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
    }

    @Override
    public void drawString(String string, float f2, float f3) {
    }

    @Override
    public void fill(Shape shape) {
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public Composite getComposite() {
        return null;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return null;
    }

    @Override
    public Paint getPaint() {
        return null;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        return false;
    }

    @Override
    public void rotate(double d2) {
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
    }

    @Override
    public void setBackground(Color color) {
    }

    @Override
    public void setComposite(Composite composite) {
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
    }

    @Override
    public void setStroke(Stroke stroke) {
        try {
            this.stroke = (BasicStroke)stroke;
            return;
        }
        catch (ClassCastException classCastException) {
            this.stroke = null;
            return;
        }
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
    }

    @Override
    public void shear(double d2, double d3) {
    }

    @Override
    public void transform(AffineTransform affineTransform) {
    }

    @Override
    public void translate(double d2, double d3) {
    }
}

