/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence.pgml;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.persistence.pgml.Container;
import org.tigris.gef.persistence.pgml.FigEdgeHandler;
import org.tigris.gef.persistence.pgml.FigGroupHandler;
import org.tigris.gef.persistence.pgml.FigLineHandler;
import org.tigris.gef.persistence.pgml.FigPolyHandler;
import org.tigris.gef.persistence.pgml.FigTextHandler;
import org.tigris.gef.persistence.pgml.HandlerFactory;
import org.tigris.gef.persistence.pgml.HandlerStack;
import org.tigris.gef.persistence.pgml.InitialHandler;
import org.tigris.gef.persistence.pgml.PrivateHandler;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.ColorFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PGMLStackParser
implements HandlerFactory,
HandlerStack {
    private static final Log LOG = LogFactory.getLog(PGMLStackParser.class);
    private Stack handlerStack;
    private XMLReader xmlReader;
    private Map ownerRegistry;
    private Diagram diagram;
    private HashMap figRegistry;
    private HashMap translationTable = new HashMap();

    public PGMLStackParser(Map map) {
        this.ownerRegistry = map;
        this.diagram = null;
    }

    public Diagram readDiagram(InputStream object, boolean bl2) {
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMementoLock(this);
        }
        try {
            object = this.readDiagram((InputStream)object, bl2, (DefaultHandler)new InitialHandler(this));
            return object;
        }
        finally {
            UndoManager.getInstance().removeMementoLock(this);
        }
    }

    private synchronized Diagram readDiagram(InputStream inputStream, boolean bl2, DefaultHandler defaultHandler) {
        this.handlerStack = new Stack();
        try {
            Object object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(false);
            ((SAXParserFactory)object).setValidating(false);
            this.figRegistry = new HashMap();
            this.diagram = null;
            object = ((SAXParserFactory)object).newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            this.xmlReader = ((SAXParser)object).getXMLReader();
            ((SAXParser)object).parse(inputSource, defaultHandler);
            if (bl2) {
                inputStream.close();
            }
            return this.diagram;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    public Diagram readDiagram(Reader reader, boolean bl2) {
        UndoManager.getInstance().isGenerateMementos();
        return this.readDiagram(reader, bl2, (DefaultHandler)new InitialHandler(this));
    }

    private synchronized Diagram readDiagram(Reader reader, boolean bl2, DefaultHandler defaultHandler) {
        this.handlerStack = new Stack();
        try {
            Object object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(false);
            ((SAXParserFactory)object).setValidating(false);
            this.figRegistry = new HashMap();
            this.diagram = null;
            object = ((SAXParserFactory)object).newSAXParser();
            InputSource inputSource = new InputSource(reader);
            this.xmlReader = ((SAXParser)object).getXMLReader();
            ((SAXParser)object).parse(inputSource, defaultHandler);
            if (bl2) {
                reader.close();
            }
            return this.diagram;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public Object findOwner(String string) {
        return this.ownerRegistry.get(string);
    }

    public void addTranslation(String string, String string2) {
        this.translationTable.put(string, string2);
    }

    @Override
    public void pushHandlerStack(DefaultHandler defaultHandler) {
        this.handlerStack.push(defaultHandler);
        if (this.xmlReader != null) {
            this.xmlReader.setContentHandler(defaultHandler);
            this.xmlReader.setErrorHandler(defaultHandler);
        }
    }

    @Override
    public void popHandlerStack() {
        this.handlerStack.pop();
        if (this.xmlReader != null && this.handlerStack.size() > 0) {
            DefaultHandler defaultHandler = (DefaultHandler)this.handlerStack.peek();
            this.xmlReader.setContentHandler(defaultHandler);
            this.xmlReader.setErrorHandler(defaultHandler);
        }
    }

    public String translateType(String string) {
        String string2 = (String)this.translationTable.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    @Override
    public DefaultHandler getHandler(HandlerStack object, Object object2, String string, String string2, String string3, Attributes attributes) {
        Object object3;
        String string4;
        String string5 = attributes.getValue("href");
        String string6 = attributes.getValue("description");
        Fig fig = null;
        if (string6 != null && (fig = this.constructFig(string4 = this.translateType(((StringTokenizer)(object3 = new StringTokenizer(string6, ",;[] "))).nextToken()), string5, this.getBounds(string6), attributes)) instanceof HandlerFactory) {
            return ((HandlerFactory)((Object)fig)).getHandler((HandlerStack)object, object2, string, string2, string3, attributes);
        }
        if (string3.equals("group")) {
            if (fig instanceof FigGroup) {
                return this.getGroupHandler(object2, (FigGroup)fig, attributes);
            }
            if (fig instanceof FigEdge) {
                this.setAttrs((FigEdge)fig, attributes);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(fig);
                }
                return new FigEdgeHandler(this, (FigEdge)fig);
            }
        }
        if (string3.equals("text")) {
            if (fig == null) {
                fig = new FigText(0, 0, 100, 100);
            }
            if (fig instanceof FigText) {
                object3 = (FigText)fig;
                this.setAttrs((Fig)object3, attributes);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(object3);
                }
                if ((string4 = attributes.getValue("font")) != null && !string4.equals("")) {
                    ((FigText)object3).setFontFamily(string4);
                }
                if ((object = attributes.getValue("textsize")) != null && !((String)object).equals("")) {
                    int n2 = Integer.parseInt((String)object);
                    ((FigText)object3).setFontSize(n2);
                }
                if ((string = attributes.getValue("justification")) != null && !string.equals("")) {
                    ((FigText)object3).setJustificationByName(string);
                }
                if ((object = attributes.getValue("italic")) != null && !((String)object).equals("")) {
                    ((FigText)object3).setItalic(Boolean.valueOf((String)object));
                }
                if ((object = attributes.getValue("bold")) != null && !((String)object).equals("")) {
                    ((FigText)object3).setBold(Boolean.valueOf((String)object));
                }
                if ((object = attributes.getValue("textcolor")) != null && !((String)object).equals("")) {
                    ((FigText)object3).setTextColor(ColorFactory.getColor((String)object));
                }
                return new FigTextHandler(this, (FigText)object3);
            }
        }
        if (string3.equals("path") || string3.equals("line")) {
            if (fig == null) {
                fig = new FigPoly();
            }
            if (fig instanceof FigLine) {
                this.setAttrs(fig, attributes);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(fig);
                }
                return new FigLineHandler(this, (FigLine)fig);
            }
            if (fig instanceof FigPoly) {
                this.setAttrs(fig, attributes);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(fig);
                }
                return new FigPolyHandler(this, (FigPoly)fig);
            }
        }
        if (string3.equals("private")) {
            if (fig != null) {
                LOG.warn((Object)("private element unexpectedly generated instance: " + fig.toString()));
            }
            if (object2 instanceof Container) {
                return new PrivateHandler(this, (Container)object2);
            }
            LOG.warn((Object)("private element with inappropriate container: " + object2.toString()));
        }
        if (string3.equals("rectangle")) {
            object3 = attributes.getValue("rounding");
            int n3 = -1;
            if (object3 != null && ((String)object3).length() > 0) {
                n3 = Integer.parseInt((String)object3);
            }
            if (fig == null) {
                fig = n3 >= 0 ? new FigRRect(0, 0, 80, 80) : new FigRect(0, 0, 80, 80);
            }
            if (fig instanceof FigRRect && n3 >= 0) {
                ((FigRRect)fig).setCornerRadius(n3);
            }
            if (fig instanceof Fig) {
                this.setAttrs(fig, attributes);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(fig);
                }
                return null;
            }
        }
        if (string3.equals("ellipse")) {
            System.out.println("Found an ellipse");
            if (fig == null) {
                System.out.println("Created a FigCircle");
                fig = new FigCircle(0, 0, 50, 50);
            }
            if (fig instanceof FigCircle) {
                object3 = (FigCircle)fig;
                this.setAttrs((Fig)object3, attributes);
                string4 = attributes.getValue("rx");
                object = attributes.getValue("ry");
                int n4 = string4 == null || string4.equals("") ? 10 : Integer.parseInt(string4);
                int n5 = object == null || ((String)object).equals("") ? 10 : Integer.parseInt((String)object);
                Object object4 = object3;
                ((Fig)object4).setBounds(((Fig)object4).getX() - n4, ((Fig)object3).getY() - n5, n4 << 1, n5 << 1);
                if (object2 instanceof Container) {
                    ((Container)object2).addObject(fig);
                }
                return null;
            }
        }
        LOG.info((Object)"Unrecognized element ".concat(String.valueOf(string3)));
        if (fig != null) {
            if (fig instanceof Fig) {
                this.setAttrs(fig, attributes);
            }
            if (object2 instanceof Container) {
                ((Container)object2).addObject(fig);
            }
        }
        return null;
    }

    protected Fig constructFig(String objectArray, String string, Rectangle rectangle, Attributes constructorArray) {
        try {
            objectArray = Class.forName((String)objectArray);
            if (string != null) {
                int n2;
                constructorArray = objectArray.getConstructors();
                for (n2 = 0; n2 < constructorArray.length; ++n2) {
                    constructorArray[n2].setAccessible(true);
                    if (constructorArray[n2].getParameterTypes().length != 5 || !constructorArray[n2].getParameterTypes()[0].equals(Object.class) || !constructorArray[n2].getParameterTypes()[1].equals(Integer.TYPE) || !constructorArray[n2].getParameterTypes()[2].equals(Integer.TYPE) || !constructorArray[n2].getParameterTypes()[3].equals(Integer.TYPE) || !constructorArray[n2].getParameterTypes()[4].equals(Integer.TYPE)) continue;
                    Object[] objectArray2 = new Object[5];
                    objectArray = objectArray2;
                    objectArray2[0] = this.findOwner(string);
                    objectArray[1] = rectangle.x;
                    objectArray[2] = rectangle.y;
                    objectArray[3] = rectangle.width;
                    objectArray[4] = rectangle.height;
                    return (Fig)constructorArray[n2].newInstance(objectArray);
                }
                for (n2 = 0; n2 < constructorArray.length; ++n2) {
                    if (constructorArray[n2].getParameterTypes().length != 3 || !constructorArray[n2].getParameterTypes()[0].equals(Object.class) || !constructorArray[n2].getParameterTypes()[1].equals(Integer.TYPE) || !constructorArray[n2].getParameterTypes()[2].equals(Integer.TYPE)) continue;
                    Object[] objectArray3 = new Object[3];
                    objectArray = objectArray3;
                    objectArray3[0] = this.findOwner(string);
                    objectArray[1] = rectangle.x;
                    objectArray[2] = rectangle.y;
                    return (Fig)constructorArray[n2].newInstance(objectArray);
                }
                for (n2 = 0; n2 < constructorArray.length; ++n2) {
                    if (constructorArray[n2].getParameterTypes().length != 1 || !constructorArray[n2].getParameterTypes()[0].equals(Object.class)) continue;
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = this.findOwner(string);
                    return (Fig)constructorArray[n2].newInstance(objectArray);
                }
            }
            return (Fig)objectArray.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SAXException(invocationTargetException);
        }
    }

    public void registerFig(Fig fig, String string) {
        this.figRegistry.put(string, fig);
    }

    public Fig findFig(String string) {
        return (Fig)this.figRegistry.get(string);
    }

    public static void setCommonAttrs(Fig fig, Attributes attributes) {
        String string;
        String string2;
        String string3;
        String string4 = attributes.getValue("x");
        if (string4 != null && !string4.equals("")) {
            String string5 = attributes.getValue("y");
            String string6 = attributes.getValue("width");
            String string7 = attributes.getValue("height");
            int n2 = Integer.parseInt(string4);
            int n3 = string5 == null || string5.equals("") ? 0 : Integer.parseInt(string5);
            int n4 = string6 == null || string6.equals("") ? 20 : Integer.parseInt(string6);
            int n5 = string7 == null || string7.equals("") ? 20 : Integer.parseInt(string7);
            fig.setBounds(n2, n3, n4, n5);
        }
        if ((string3 = attributes.getValue("stroke")) != null && !string3.equals("")) {
            fig.setLineWidth(Integer.parseInt(string3));
        }
        if ((string2 = attributes.getValue("strokecolor")) != null && !string2.equals("")) {
            fig.setLineColor(ColorFactory.getColor(string2, Color.blue));
        }
        if ((string = attributes.getValue("fill")) != null && !string.equals("")) {
            fig.setFilled(string.equals("1") || string.startsWith("t"));
        }
        if ((string4 = attributes.getValue("fillcolor")) != null && !string4.equals("")) {
            fig.setFillColor(ColorFactory.getColor(string4, Color.white));
        }
        if ((string3 = attributes.getValue("dasharray")) != null && !string3.equals("") && !string3.equals("solid")) {
            fig.setDashed(true);
        }
        if ((string2 = attributes.getValue("context")) != null && !string2.equals("")) {
            fig.setContext(string2);
        }
        if ((string = attributes.getValue("visible")) != null && !string.equals("")) {
            int n6 = Integer.parseInt(string);
            fig.setVisible(n6 != 0);
        }
    }

    protected void setAttrs(Fig fig, Attributes object) {
        Object object2 = object.getValue("name");
        if (object2 != null && !((String)object2).equals("")) {
            this.figRegistry.put(object2, fig);
        }
        PGMLStackParser.setCommonAttrs(fig, (Attributes)object);
        object = object.getValue("href");
        if (object != null && !((String)object).equals("")) {
            object2 = this.findOwner((String)object);
            if (object2 == null) {
                throw new SAXException("Found href of " + (String)object + " with no matching element in model");
            }
            if (fig.getOwner() != object2) {
                fig.setOwner(object2);
                return;
            }
            LOG.info((Object)("Ignoring href on " + fig.getClass().getName() + " as it's already set"));
        }
    }

    private DefaultHandler getGroupHandler(Object object, FigGroup figGroup, Attributes object2) {
        if (object instanceof Container) {
            ((Container)object).addObject(figGroup);
        }
        object = new StringTokenizer(object2.getValue("description"), ",;[] ");
        this.setAttrs(figGroup, (Attributes)object2);
        if (((StringTokenizer)object).hasMoreElements()) {
            ((StringTokenizer)object).nextToken();
        }
        object2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (((StringTokenizer)object).hasMoreElements()) {
            object2 = ((StringTokenizer)object).nextToken();
            string = ((StringTokenizer)object).nextToken();
            string2 = ((StringTokenizer)object).nextToken();
            string3 = ((StringTokenizer)object).nextToken();
        }
        if (object2 != null && !((String)object2).equals("")) {
            int n2 = Integer.parseInt((String)object2);
            int n3 = Integer.parseInt(string);
            int n4 = Integer.parseInt(string2);
            int n5 = Integer.parseInt(string3);
            figGroup.setBounds(n2, n3, n4, n5);
        }
        return new FigGroupHandler(this, figGroup);
    }

    Rectangle getBounds(String object) {
        try {
            int n2 = ((String)object).indexOf(91);
            if (n2 < 0) {
                return null;
            }
            object = ((String)object).substring(n2 + 1);
            object = new StringTokenizer((String)object, ", ]");
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (((StringTokenizer)object).hasMoreElements()) {
                string = ((StringTokenizer)object).nextToken();
                string2 = ((StringTokenizer)object).nextToken();
                string3 = ((StringTokenizer)object).nextToken();
                string4 = ((StringTokenizer)object).nextToken();
            }
            if (string != null && !string.equals("")) {
                int n3 = Integer.parseInt(string);
                int n4 = Integer.parseInt(string2);
                int n5 = Integer.parseInt(string3);
                int n6 = Integer.parseInt(string4);
                return new Rectangle(n3, n4, n5, n6);
            }
        }
        catch (Exception exception) {
            LOG.warn((Object)"Exception extracting bounds from description", (Throwable)exception);
        }
        return null;
    }
}

