/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Point;
import java.util.Enumeration;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationHelper;
import org.tigris.gef.presentation.AnnotationLineRemover;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigLine;

public class EdgeAnnotationStrategy
extends AnnotationStrategy {
    private static final long serialVersionUID = 839904139158340787L;
    AnnotationHelper helper = AnnotationHelper.instance();

    @Override
    public Point restoreAnnotationPosition(Fig fig) {
        Fig fig2 = fig.getAnnotationOwner();
        if (fig2 instanceof FigEdge) {
            Point point;
            Point point2;
            AnnotationProperties annotationProperties = (AnnotationProperties)this.annotations.get(fig);
            int n2 = annotationProperties.getOffset();
            float f2 = annotationProperties.getRatio();
            fig2 = (FigEdge)fig2;
            try {
                point2 = ((FigEdge)fig2).getFirstPoint();
                point = ((FigEdge)fig2).getLastPoint();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                try {
                    point2 = ((FigEdge)fig2).getSourcePortFig().getCenter();
                    point = ((FigEdge)fig2).getDestPortFig().getCenter();
                }
                catch (NullPointerException nullPointerException) {
                    point2 = new Point(10, 10);
                    point = new Point(100, 10);
                }
            }
            if (point2.x == point.x && point2.y == point.y) {
                return fig.getLocation();
            }
            float f3 = point.x - point2.x;
            float f4 = point.y - point2.y;
            double d2 = (float)point2.x + f2 * f3;
            double d3 = (float)point2.y + f2 * f4;
            float f5 = f3;
            float f6 = f4;
            float f7 = f3;
            float f8 = f4;
            return new Point((int)(d2 += (double)n2 * ((double)f4 / Math.sqrt(f5 * f5 + f6 * f6))) - fig.getWidth() / 2, (int)(d3 += (double)(-n2) * ((double)f3 / Math.sqrt(f7 * f7 + f8 * f8))) - fig.getHeight() / 2);
        }
        return new Point(1, 1);
    }

    @Override
    public void storeAnnotationPosition(Fig fig) {
        Fig fig2 = fig.getAnnotationOwner();
        if (fig2 instanceof FigEdge) {
            Point point;
            Object object;
            fig2 = (FigEdge)fig2;
            Point point2 = fig.getCenter();
            try {
                object = ((FigEdge)fig2).getFirstPoint();
                point = ((FigEdge)fig2).getLastPoint();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                object = ((FigEdge)fig2).getSourcePortFig().getCenter();
                point = ((FigEdge)fig2).getDestPortFig().getCenter();
            }
            if (((Point)object).x == point.x && ((Point)object).y == point.y) {
                return;
            }
            int n2 = AnnotationHelper.getNormOffset(point2, (Point)object, point);
            float f2 = AnnotationHelper.getRatio(point2, (Point)object, point);
            object = this.getAnnotationProperties(fig);
            ((AnnotationProperties)object).setRatio(f2, ((AnnotationProperties)object).hasFixedRatio());
            ((AnnotationProperties)object).setOffset(n2, ((AnnotationProperties)object).hasFixedOffset());
        }
        this.drawConnectingLine(fig);
    }

    public void drawConnectingLine(Fig fig) {
        if (!this.getAnnotationProperties(fig).lineIsVisible(fig)) {
            return;
        }
        Fig fig2 = fig.getAnnotationOwner();
        FigLine figLine = this.getAnnotationProperties(fig).getConnectingLine();
        if (((FigEdge)fig2).getSourcePortFig().getCenter() == null || ((FigEdge)fig2).getDestPortFig().getCenter() == null) {
            return;
        }
        try {
            if (fig2 instanceof FigEdgePoly) {
                figLine.setShape(fig.getCenter(), AnnotationHelper.getClosestPoint(fig.getCenter(), (FigEdgePoly)fig2));
            } else {
                figLine.setShape(fig.getCenter(), AnnotationHelper.getClosestPointOnEdge(fig.getCenter(), ((FigEdge)fig2).getFirstPoint(), ((FigEdge)fig2).getLastPoint()));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            figLine.setShape(fig.getCenter(), AnnotationHelper.getClosestPointOnEdge(fig.getCenter(), ((FigEdge)fig2).getSourcePortFig().getCenter(), ((FigEdge)fig2).getDestPortFig().getCenter()));
        }
        figLine.setLineColor(this.getAnnotationProperties(fig).getLineColor());
        figLine.setFillColor(this.getAnnotationProperties(fig).getLineColor());
        figLine.setDashed(true);
        if (!Globals.curEditor().getLayerManager().getContents().contains(figLine)) {
            Globals.curEditor().add(figLine);
        }
        Globals.curEditor().getLayerManager().bringToFront(fig);
        figLine.damage();
        fig.damage();
        AnnotationLineRemover.instance().removeLineIn(this.getAnnotationProperties(fig).getLineVisibilityDuration(), fig);
    }

    @Override
    public void translateAnnotations(Fig fig) {
        Enumeration enumeration = this.annotations.keys();
        while (enumeration.hasMoreElements()) {
            Fig fig2 = (Fig)enumeration.nextElement();
            fig2.setLocation(this.restoreAnnotationPosition(fig2));
            Globals.curEditor().getLayerManager().bringToFront(fig2);
            fig2.endTrans();
            fig2.damage();
        }
        fig.damage();
    }
}

