/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.Fig$1;
import org.tigris.gef.presentation.Fig$1FigRemoveMemento;
import org.tigris.gef.presentation.Fig$1TranslateMemento;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.presentation.NoAnnotationStrategy;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.ui.PopupGenerator;
import org.tigris.gef.undo.UndoManager;
import org.tigris.gef.util.Localizer;

public abstract class Fig
implements PropertyChangeListener,
Serializable,
Cloneable,
DiagramElement,
PopupGenerator {
    public static final int MIN_SIZE = 4;
    private static final String[] DASHED_CHOICES = new String[]{"Solid", "Dashed", "LongDashed", "Dotted", "DotDash"};
    private static final float[][] DASH_ARRAYS = new float[][]{null, {5.0f, 5.0f}, {15.0f, 5.0f}, {3.0f, 10.0f}, {3.0f, 6.0f, 10.0f, 6.0f}};
    private static final int[] DASH_PERIOD = new int[]{0, 10, 20, 13, 25};
    boolean movable = true;
    boolean resizable = true;
    private transient Layer layer = null;
    private boolean locked = false;
    private transient Object owner;
    protected int _x;
    protected int _y;
    protected int _w;
    protected int _h;
    private String resource = "";
    Color _lineColor = Color.black;
    Color _fillColor = Color.white;
    int _lineWidth = 1;
    protected float[] _dashes = null;
    protected int _dashStyle = 0;
    protected int _dashPeriod = 0;
    protected boolean _filled = true;
    private Fig group = null;
    protected String _context = "";
    private boolean visible = true;
    protected boolean _allowsSaving = true;
    private transient boolean _selected = false;
    private boolean removeStarted;
    public static final int BORDER = 8;
    protected AnnotationStrategy an = NoAnnotationStrategy.getInstance();
    protected boolean annotationStatus = false;
    protected Fig annotationOwner;

    public Fig() {
    }

    public Fig(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, Color.black, Color.white);
    }

    public Fig(int n2, int n3, int n4, int n5, Color color, Color color2) {
        this();
        this._x = n2;
        this._y = n3;
        this._w = n4;
        this._h = n5;
        if (color != null) {
            this._lineColor = color;
        } else {
            this._lineWidth = 0;
        }
        if (color2 != null) {
            this._fillColor = color2;
            return;
        }
        this._filled = false;
    }

    public Fig(int n2, int n3, int n4, int n5, Color color, Color color2, Object object) {
        this(n2, n3, n4, n5, color, color2);
        this.setOwner(object);
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setAnnotationOwner(Fig fig) {
        this.annotationOwner = fig;
        Fig fig2 = this;
        fig2.setAnnotationStatus(fig2.annotationOwner != null);
    }

    public void unsetAnnotationOwner() {
        this.annotationOwner = null;
        this.setAnnotationStatus(false);
    }

    public Fig getAnnotationOwner() {
        return this.annotationOwner;
    }

    public AnnotationStrategy getAnnotationStrategy() {
        return this.an;
    }

    public void setAnnotationStrategy(AnnotationStrategy annotationStrategy) {
        this.an = annotationStrategy;
    }

    public boolean isAnnotation() {
        return this.annotationStatus;
    }

    public void setAnnotationStatus(boolean bl2) {
        this.annotationStatus = bl2;
    }

    public final void addAnnotation(Fig fig, String string, String string2) {
    }

    public final void removeAnnotation(Fig fig) {
        if (fig.isAnnotation() && this == fig.getAnnotationOwner()) {
            Globals.curEditor().remove(fig);
            this.getAnnotationStrategy().removeAnnotation(fig);
        }
    }

    public final void translateAnnotations() {
        SelectionManager selectionManager;
        if (this.isAnnotation() && !(selectionManager = Globals.curEditor().getSelectionManager()).containsFig(this.getAnnotationOwner()) && selectionManager.containsFig(this)) {
            this.getAnnotationOwner().an.storeAnnotationPosition(this);
        }
        if (!(this.getAnnotationStrategy() instanceof NoAnnotationStrategy)) {
            this.getAnnotationStrategy().translateAnnotations(this);
        }
    }

    public final void updateAnnotationPositions() {
        Enumeration enumeration = this.getAnnotationStrategy().getAllAnnotations();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            this.getAnnotationStrategy().storeAnnotationPosition(fig);
            fig.endTrans();
        }
        this.endTrans();
    }

    public final void initAnnotations() {
    }

    public void addPoint(int n2, int n3) {
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Globals.addPropertyChangeListener(this, propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Globals.removePropertyChangeListener(this, propertyChangeListener);
    }

    public final void align(Rectangle cloneable, int n2, Editor editor) {
        Rectangle rectangle = this.getBounds();
        int n3 = 0;
        int n4 = 0;
        switch (n2) {
            case 0: {
                n4 = cloneable.y - rectangle.y;
                break;
            }
            case 1: {
                n4 = cloneable.y + cloneable.height - (rectangle.y + rectangle.height);
                break;
            }
            case 2: {
                n3 = cloneable.x - rectangle.x;
                break;
            }
            case 3: {
                n3 = cloneable.x + cloneable.width - (rectangle.x + rectangle.width);
                break;
            }
            case 4: {
                n3 = cloneable.x + cloneable.width / 2 - (rectangle.x + rectangle.width / 2);
                n4 = cloneable.y + cloneable.height / 2 - (rectangle.y + rectangle.height / 2);
                break;
            }
            case 5: {
                n3 = cloneable.x + cloneable.width / 2 - (rectangle.x + rectangle.width / 2);
                break;
            }
            case 6: {
                n4 = cloneable.y + cloneable.height / 2 - (rectangle.y + rectangle.height / 2);
                break;
            }
            case 7: {
                cloneable = this.getLocation();
                Point point = new Point(((Point)cloneable).x, ((Point)cloneable).y);
                editor.snap(point);
                n3 = point.x - ((Point)cloneable).x;
                n4 = point.y - ((Point)cloneable).y;
            }
        }
        this.translate(n3, n4);
    }

    public void calcBounds() {
    }

    public final Point center() {
        return this.getCenter();
    }

    public Point getCenter() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public String classNameAndBounds() {
        return this.getClass().getName() + "[" + this.getX() + ", " + this.getY() + ", " + this.getWidth() + ", " + this.getHeight() + "]";
    }

    public void cleanUp() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean isCopyable() {
        return true;
    }

    public boolean isCutable() {
        return true;
    }

    public Point connectionPoint(Point point) {
        List list = this.getGravityPoints();
        if (list != null && list.size() > 0) {
            int n2 = point.x;
            int n3 = point.y;
            Point point2 = (Point)list.get(0);
            int n4 = Integer.MAX_VALUE;
            int n5 = list.size();
            for (int i2 = 0; i2 < n5; ++i2) {
                Point point3 = (Point)list.get(i2);
                int n6 = point3.x - n2;
                int n7 = point3.y - n3;
                int n8 = n6;
                int n9 = n7;
                n6 = n8 * n8 + n9 * n9;
                if (n6 >= n4) continue;
                n4 = n6;
                point2 = point3;
            }
            return new Point(point2.x, point2.y);
        }
        return this.getClosestPoint(point);
    }

    public boolean contains(int n2, int n3) {
        return this._x <= n2 && n2 <= this._x + this._w && this._y <= n3 && n3 <= this._y + this._h;
    }

    public final boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public final boolean contains(Rectangle rectangle) {
        return this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height) == 4;
    }

    protected int countCornersContained(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (this.contains(n2, n3)) {
            ++n6;
        }
        if (this.contains(n2 + n4, n3)) {
            ++n6;
        }
        if (this.contains(n2, n3 + n5)) {
            ++n6;
        }
        if (this.contains(n2 + n4, n3 + n5)) {
            ++n6;
        }
        return n6;
    }

    public void createDrag(int n2, int n3, int n4, int n5, int n6, int n7) {
        n4 = Math.min(n2, n6);
        n5 = Math.min(n3, n7);
        n2 = Math.max(n2, n6) - n4;
        n3 = Math.max(n3, n7) - n5;
        this.setBounds(n4, n5, n2, n3);
    }

    public void endTrans() {
        this.translateAnnotations();
        this.damage();
    }

    public void damage() {
        Layer layer = this.getLayer();
        for (Fig fig = this.getGroup(); layer == null && fig != null; fig = fig.getGroup()) {
            layer = fig.getLayer();
        }
        if (layer != null) {
            layer.damageAll();
        }
    }

    public Rectangle getHandleBox() {
        return this.getBounds();
    }

    public void setHandleBox(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5);
    }

    public void removeFromDiagram() {
        Serializable serializable;
        if (UndoManager.getInstance().isGenerateMementos()) {
            Fig fig = this;
            UndoManager.getInstance().addMemento(new Fig$1FigRemoveMemento(fig, fig));
        }
        this.removeStarted = true;
        this.visible = false;
        Enumeration enumeration = this.getAnnotationStrategy().getAllAnnotations();
        while (enumeration.hasMoreElements()) {
            serializable = (Fig)enumeration.nextElement();
            this.getAnnotationStrategy().getAnnotationProperties((Fig)serializable).removeLine();
            this.removeAnnotation((Fig)serializable);
            ((Fig)serializable).removeFromDiagram();
        }
        if (this.layer != null) {
            serializable = this.layer;
            this.layer.remove(this);
            ((Layer)serializable).deleted(this);
        }
        this.setEnclosingFig(null);
    }

    public void deleteFromModel() {
        this.removeStarted = true;
        Object object = this.getOwner();
        if (object instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object).deleteFromModel();
            return;
        }
        if (object instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object).deleteFromModel();
            return;
        }
        if (object instanceof GraphPortHooks) {
            ((GraphPortHooks)object).deleteFromModel();
            return;
        }
        this.removeFromDiagram();
    }

    /*
     * WARNING - void declaration
     */
    public void drawRect(Graphics graphics, boolean bl2, Color color, int n2, Color color2, int n3, int n4, int n5, int n6, boolean bl3, float[] fArray, int n7) {
        void var12_14;
        void var11_13;
        void var10_12;
        void var4_6;
        void var5_7;
        void var9_11;
        void var8_10;
        void var7_9;
        void var6_8;
        void var3_5;
        if (bl2 && var3_5 != null) {
            void var2_4;
            void var2_3 = var6_8;
            var6_8 = var7_9;
            var7_9 = var8_10;
            void var13_15 = var9_11;
            if (var5_7 != null && var4_6 > true && var10_12 == false && var5_7 != var3_5) {
                var13_15 = var4_6 << 1;
                graphics.setColor((Color)var5_7);
                graphics.fillRect((int)var2_3, (int)var6_8, (int)var8_10, (int)var9_11);
                var2_4 = var2_3 + var4_6;
                var6_8 += var4_6;
                var7_9 = var8_10 - var13_15;
                var13_15 = var9_11 - var13_15;
            }
            graphics.setColor((Color)var3_5);
            graphics.fillRect((int)var2_4, (int)var6_8, (int)var7_9, (int)var13_15);
            if (var5_7 != null && var5_7 != var3_5 && (var4_6 == true || var10_12 != false)) {
                this.paintRectLine(graphics, (int)var2_4, (int)var6_8, (int)var7_9, (int)var13_15, (int)var4_6, (Color)var5_7, (boolean)var10_12, (float[])var11_13, (int)var12_14);
            }
            return;
        }
        this.paintRectLine(graphics, (int)var6_8, (int)var7_9, (int)var8_10, (int)var9_11, (int)var4_6, (Color)var5_7, (boolean)var10_12, (float[])var11_13, (int)var12_14);
    }

    private void paintRectLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl2, float[] fArray, int n7) {
        if (n6 > 0 && color != null) {
            graphics.setColor(color);
            if (n6 == 1) {
                this.paintRectLine(graphics, n2, n3, n4, n5, bl2, n6, fArray, n7);
                return;
            }
            for (int i2 = 0; i2 < n6; ++i2) {
                this.paintRectLine(graphics, n2++, n3++, n4, n5, bl2, n6, fArray, n7);
                n4 -= 2;
                n5 -= 2;
            }
        }
    }

    private void paintRectLine(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, int n6, float[] fArray, int n7) {
        if (!bl2) {
            graphics.drawRect(n2, n3, n4, n5);
            return;
        }
        this.drawDashedRectangle(graphics, 0, n2, n3, n4, n5, n6, fArray, n7);
    }

    private void drawDashedRectangle(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray, int n8) {
        n2 = this.drawDashedLine(graphics, n7, n3, n4, n3 + n5, n4, n2, fArray, n8);
        n2 = this.drawDashedLine(graphics, n7, n3 + n5, n4, n3 + n5, n4 + n6, n2, fArray, n8);
        n2 = this.drawDashedLine(graphics, n7, n3 + n5, n4 + n6, n3, n4 + n6, n2, fArray, n8);
        this.drawDashedLine(graphics, n7, n3, n4 + n6, n3, n4, n2, fArray, n8);
    }

    public int drawDashedLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray, int n8) {
        int n9;
        if (graphics instanceof Graphics2D) {
            return this.drawDashedLineG2D((Graphics2D)graphics, n2, n7, n3, n4, n5, n6, fArray, n8);
        }
        n2 = (n5 - n3) * (n5 - n3);
        n8 = (n6 - n4) * (n6 - n4);
        int n10 = (int)Math.sqrt(n2 + n8);
        int n11 = fArray.length;
        int n12 = 0;
        for (n9 = 0; n9 < n11; ++n9) {
            n12 = (int)((float)n12 + fArray[n9]);
        }
        n9 = 0;
        int n13 = 0;
        while (n13 < n10) {
            int n14;
            int n15;
            n2 = n3 + (n5 - n3) * n13 / n10;
            n8 = n4 + (n6 - n4) * n13 / n10;
            n13 = (int)((float)n13 + fArray[n9]);
            n9 = (n9 + 1) % n11;
            if (n13 >= n10) {
                n15 = n5;
                n14 = n6;
            } else {
                n15 = n3 + (n5 - n3) * n13 / n10;
                n14 = n4 + (n6 - n4) * n13 / n10;
            }
            graphics.drawLine(n2, n8, n15, n14);
            n13 = (int)((float)n13 + fArray[n9]);
            n9 = (n9 + 1) % n11;
        }
        return (n10 + n7) % n12;
    }

    private int drawDashedLineG2D(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, int n7, float[] fArray, int n8) {
        int n9 = (n6 - n4) * (n6 - n4);
        int n10 = (n7 - n5) * (n7 - n5);
        n9 = (int)(Math.sqrt(n9 + n10) + 0.5);
        Stroke stroke = graphics2D.getStroke();
        Stroke stroke2 = this.getDefaultStroke(n2, fArray, n3);
        graphics2D.setStroke(stroke2);
        graphics2D.draw(new Line2D.Float(n4, n5, n6, n7));
        graphics2D.setStroke(stroke);
        return (n9 + n3) % n8;
    }

    public final void firePropChange(String string, int n2, int n3) {
        this.firePropChange(string, (Object)n2, (Object)n3);
    }

    public final void firePropChange(String object, Object object2, Object object3) {
        Globals.firePropChange((Object)this, (String)object, object2, object3);
        if (this.group != null) {
            object = new PropertyChangeEvent(this, (String)object, object2, object3);
            this.group.propertyChange((PropertyChangeEvent)object);
        }
    }

    public final void firePropChange(String string, boolean bl2, boolean bl3) {
        this.firePropChange(string, (Object)bl2, (Object)bl3);
    }

    public final Rectangle getBounds() {
        return this.getBounds(null);
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this._x, this._y, this._w, this._h);
        }
        rectangle.setBounds(this._x, this._y, this._w, this._h);
        return rectangle;
    }

    public Point getClosestPoint(Point point) {
        return Geometry.ptClosestTo(this.getBounds(), point);
    }

    public boolean getDashed() {
        return this._dashes != null;
    }

    public float[] getDashes() {
        return this._dashes;
    }

    public int getDashPeriod() {
        return this._dashPeriod;
    }

    public final int getDashed01() {
        if (this.getDashed()) {
            return 1;
        }
        return 0;
    }

    public final String getDashedString() {
        if (this._dashes == null) {
            return DASHED_CHOICES[0];
        }
        return DASHED_CHOICES[1];
    }

    public Vector getEnclosedFigs() {
        return null;
    }

    public Fig getEnclosingFig() {
        return null;
    }

    public boolean hasFillColor() {
        return true;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public boolean getFilled() {
        return this._filled;
    }

    public boolean isFilled() {
        return this._filled;
    }

    public final int getFilled01() {
        if (this._filled) {
            return 1;
        }
        return 0;
    }

    public boolean hasLineColor() {
        return true;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public Point getFirstPoint() {
        return new Point();
    }

    public List getGravityPoints() {
        return null;
    }

    public final Fig getGroup() {
        return this.group;
    }

    public final String getContext() {
        return this._context;
    }

    public final int getHalfHeight() {
        return this._h / 2;
    }

    public final int getHalfWidth() {
        return this._w / 2;
    }

    @Override
    public String getId() {
        if (this.getGroup() != null) {
            String string = this.getGroup().getId();
            if (this.getGroup() instanceof FigGroup) {
                return string + "." + ((FigGroup)this.getGroup()).getFigs().indexOf(this);
            }
            if (this.getGroup() instanceof FigEdge) {
                return string + "." + (((FigEdge)this.getGroup()).getPathItemFigs().indexOf(this) + 1);
            }
            return string + ".0";
        }
        Layer layer = this.getLayer();
        if (layer == null) {
            return "LAYER_NULL";
        }
        int n2 = layer.getContents().indexOf(this);
        return "Fig".concat(String.valueOf(n2));
    }

    public Point getLastPoint() {
        return new Point();
    }

    public final Layer getLayer() {
        return this.layer;
    }

    public final Point getLocation() {
        return new Point(this._x, this._y);
    }

    public final boolean getLocked() {
        return this.locked;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(4, 4);
    }

    public int getNumPoints() {
        return 0;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    public int getPerimeterLength() {
        return this._w + this._w + this._h + this._h;
    }

    public Point[] getPoints() {
        return new Point[0];
    }

    public Point getPoint(int n2) {
        return null;
    }

    @Override
    public Vector getPopUpActions(MouseEvent serializable) {
        serializable = new Vector();
        JMenu jMenu = new JMenu(Localizer.localize("PresentationGef", "Ordering"));
        jMenu.setMnemonic(Localizer.localize("PresentationGef", "OrderingMnemonic").charAt(0));
        jMenu.add(CmdReorder.BringForward);
        jMenu.add(CmdReorder.SendBackward);
        jMenu.add(CmdReorder.BringToFront);
        jMenu.add(CmdReorder.SendToBack);
        ((Vector)serializable).addElement(jMenu);
        return serializable;
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this._w, this._h);
    }

    public String getPrivateData() {
        return "";
    }

    public Dimension getSize() {
        return new Dimension(this._w, this._h);
    }

    public String getTipString(MouseEvent mouseEvent) {
        if (this.owner == null) {
            return this.toString();
        }
        return this.owner.toString();
    }

    public Rectangle getTrapRect() {
        return this.getBounds();
    }

    public List<Rectangle> getTrapRects(Fig cloneable) {
        cloneable = new ArrayList<Rectangle>(1);
        ((ArrayList)cloneable).add(this.getTrapRect());
        return cloneable;
    }

    public boolean getUseTrapRect() {
        return false;
    }

    public final int getVisState() {
        if (this.isVisible()) {
            return 1;
        }
        return 0;
    }

    public final int getWidth() {
        return this._w;
    }

    public final int getHeight() {
        return this._h;
    }

    public final int getX() {
        return this._x;
    }

    public final int getY() {
        return this._y;
    }

    public int[] getXs() {
        return new int[0];
    }

    public int[] getYs() {
        return new int[0];
    }

    public boolean hit(Rectangle rectangle) {
        if (!this.isVisible() || !this.isSelectable()) {
            return false;
        }
        int n2 = this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this._filled) {
            return n2 > 0;
        }
        return n2 > 0 && n2 < 4;
    }

    public void insertPoint(int n2, int n3, int n4) {
    }

    public boolean intersects(Rectangle rectangle) {
        return rectangle.x + rectangle.width >= this._x && rectangle.y + rectangle.height >= this._y && rectangle.x <= this._x + this._w && rectangle.y <= this._y + this._h;
    }

    public boolean intersectsPerimeter(Rectangle rectangle) {
        return rectangle.intersectsLine(this._x, this._y, this._x, this._y + this._h) && rectangle.intersectsLine(this._x, this._y + this._h, this._x + this._w, this._y + this._h) && rectangle.intersectsLine(this._x + this._w, this._y + this._h, this._x + this._w, this._y) && rectangle.intersectsLine(this._x + this._w, this._y, this._x, this._y);
    }

    public final boolean isLowerRightResizable() {
        return false;
    }

    public final boolean isMovable() {
        return this.movable;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public Selection makeSelection() {
        return null;
    }

    public abstract void paint(Graphics var1);

    public abstract void appendSvg(StringBuffer var1);

    protected void appendSvgStyle(StringBuffer stringBuffer) {
        stringBuffer.append(" style='fill:rgb(").append(this.getFillColor().getRed()).append(",").append(this.getFillColor().getGreen()).append(",").append(this.getFillColor().getBlue()).append(");stroke-width:").append(this.getLineWidth()).append(";stroke:rgb(").append(this.getLineColor().getRed()).append(",").append(this.getLineColor().getGreen()).append(",").append(this.getLineColor().getBlue()).append(");'");
    }

    public final Point pointAlongPerimeter(int n2) {
        Point point = new Point();
        this.stuffPointAlongPerimeter(n2, point);
        return point;
    }

    public void postLoad() {
    }

    public void postSave() {
    }

    public void preSave() {
    }

    public final void print(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.group != null) {
            this.group.propertyChange(propertyChangeEvent);
        }
    }

    public final void redraw() {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.damage();
    }

    public void removePoint(int n2) {
    }

    public final void reorder(int n2, Layer layer) {
        layer.reorder(this, n2);
    }

    public final Rectangle routingRect() {
        return new Rectangle(this._x - 8, this._y - 8, this._w + 16, this._h + 16);
    }

    public final void setBounds(int n2, int n3, int n4, int n5) {
        if (this.group == null && (n2 != this._x || n3 != this._y || n4 != this._w || n5 != this._h)) {
            MutableGraphSupport.enableSaveAction();
            if (UndoManager.getInstance().isGenerateMementos()) {
                Fig$1 fig$1 = new Fig$1(this, n2, n3, n4, n5);
                UndoManager.getInstance().addMemento(fig$1);
            }
        }
        this.setBoundsImpl(n2, n3, n4, n5);
    }

    protected void setBoundsImpl(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        this._x = n2;
        this._y = n3;
        this._w = n4;
        this._h = n5;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public final void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void setCenter(Point point) {
        int n2 = point.x - this._w / 2;
        int n3 = point.y - this._h / 2;
        this.setLocation(n2, n3);
    }

    public void setEnclosingFig(Fig fig) {
        if (fig != null && fig != this.getEnclosingFig() && this.layer != null) {
            this.layer.bringInFrontOf(this, fig);
            this.damage();
        }
    }

    public final void setGroup(Fig fig) {
        this.group = fig;
    }

    public final void setContext(String string) {
        this._context = string;
    }

    public void setLayer(Layer layer) {
        this.firePropChange("layer", this.layer, layer);
        this.layer = layer;
    }

    public void setFillColor(Color color) {
        if (color == null ? this._fillColor == null : color.equals(this._fillColor)) {
            return;
        }
        if (color != null) {
            this.firePropChange("fillColor", this._fillColor, color);
            this._fillColor = color;
        } else {
            this.firePropChange("filled", this._filled, false);
            this._filled = false;
        }
        MutableGraphSupport.enableSaveAction();
    }

    public void setFilled(boolean bl2) {
        this.firePropChange("filled", this._filled, bl2);
        this._filled = bl2;
    }

    public void setLineColor(Color color) {
        if (color == null ? this._lineColor == null : color.equals(this._lineColor)) {
            return;
        }
        if (color != null) {
            this.firePropChange("lineColor", this._lineColor, color);
            this._lineColor = color;
        } else {
            this.firePropChange("lineWidth", this._lineWidth, 0);
            this._lineWidth = 0;
        }
        MutableGraphSupport.enableSaveAction();
    }

    public void setLineWidth(int n2) {
        n2 = Math.max(0, n2);
        this.firePropChange("lineWidth", this._lineWidth, n2);
        this._lineWidth = n2;
    }

    public void setDashed(boolean bl2) {
        if (bl2) {
            this._dashes = DASH_ARRAYS[1];
            this._dashPeriod = DASH_PERIOD[1];
            return;
        }
        this._dashes = null;
    }

    public void setDashedString(String string) {
        this.setDashed(string.equalsIgnoreCase("solid"));
    }

    public final void setLocation(int n2, int n3) {
        this.translate(n2 - this._x, n3 - this._y);
    }

    public final void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public final void setLocked(boolean bl2) {
        this.firePropChange("locked", this.locked, bl2);
        this.locked = bl2;
    }

    public void setNumPoints(int n2) {
    }

    public void setOwner(Object object) {
        this.firePropChange("owner", this.owner, object);
        this.owner = object;
    }

    public void setPoints(Point[] pointArray) {
    }

    public void setPoint(int n2, int n3, int n4) {
    }

    public final void setPoint(int n2, Point point) {
        this.setPoint(n2, point.x, point.y);
    }

    public void setPoint(Handle handle, int n2, int n3) {
        this.setPoint(handle.index, n2, n3);
    }

    public final void setPoint(Handle handle, Point point) {
        this.setPoint(handle, point.x, point.y);
    }

    public void setPrivateData(String string) {
    }

    public final void setSize(int n2, int n3) {
        Fig fig = this;
        fig.setBounds(fig._x, this._y, n2, n3);
    }

    public final void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public final void setWidth(int n2) {
        Fig fig = this;
        fig.setBounds(fig._x, this._y, n2, this._h);
    }

    public final void setHeight(int n2) {
        Fig fig = this;
        fig.setBounds(fig._x, this._y, this._w, n2);
    }

    public final void setX(int n2) {
        this.setBounds(n2, this._y, this._w, this._h);
    }

    public void setXs(int[] nArray) {
    }

    public final void setY(int n2) {
        Fig fig = this;
        fig.setBounds(fig._x, n2, this._w, this._h);
    }

    public void setYs(int[] nArray) {
    }

    public final void stuffBounds(Rectangle rectangle) {
        rectangle.setBounds(this._x, this._y, this._w, this._h);
    }

    public void stuffPointAlongPerimeter(int n2, Point point) {
        if (n2 < this._w && n2 >= 0) {
            point.x = this._x + n2;
            point.y = this._y;
            return;
        }
        if (n2 < this._w + this._h) {
            point.x = this._x + this._w;
            point.y = this._y + (n2 - this._w);
            return;
        }
        if (n2 < this._w + this._h + this._w) {
            point.x = this._x + this._w - (n2 - this._w - this._h);
            point.y = this._y + this._h;
            return;
        }
        if (n2 < this._w + this._h + this._w + this._h) {
            point.x = this._x;
            point.y = this._y + (this._w + this._h + this._w + this._h - n2);
            return;
        }
        point.x = this._x;
        point.y = this._y;
    }

    public void translate(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return;
        }
        if (this.group == null && UndoManager.getInstance().isGenerateMementos()) {
            Fig fig = this;
            UndoManager.getInstance().addMemento(new Fig$1TranslateMemento(fig, fig._x, this._y, this._w, this._h, n2, n3));
        }
        MutableGraphSupport.enableSaveAction();
        this.translateImpl(n2, n3);
    }

    protected void translateImpl(int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        this._x += n2;
        this._y += n3;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public final boolean within(Rectangle rectangle) {
        return rectangle.contains(this._x, this._y) && rectangle.contains(this._x + this._w, this._y + this._h);
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        if (this.visible == bl2) {
            return;
        }
        MutableGraphSupport.enableSaveAction();
        this.visible = bl2;
    }

    public void setResizable(boolean bl2) {
        this.resizable = bl2;
    }

    public void setMovable(boolean bl2) {
        this.movable = bl2;
    }

    public final boolean isRemoveStarted() {
        return this.removeStarted;
    }

    protected Stroke getDefaultStroke(int n2) {
        float[] fArray = null;
        if (this.getDashed()) {
            fArray = this._dashes;
        }
        return this.getDefaultStroke(n2, fArray, 0.0f);
    }

    protected Stroke getDefaultStroke(float f2, float[] fArray, float f3) {
        return new BasicStroke(f2, 2, 0, 10.0f, fArray, f3);
    }

    protected Paint getDefaultPaint(Color color, Color color2, int n2, int n3, int n4, int n5) {
        return color;
    }

    static /* synthetic */ boolean access$002(Fig fig, boolean bl2) {
        fig.visible = bl2;
        return fig.visible;
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "x");
        PropCategoryManager.categorizeProperty("Geometry", "y");
        PropCategoryManager.categorizeProperty("Geometry", "width");
        PropCategoryManager.categorizeProperty("Geometry", "height");
        PropCategoryManager.categorizeProperty("Geometry", "filled");
        PropCategoryManager.categorizeProperty("Geometry", "locked");
        PropCategoryManager.categorizeProperty("Style", "lineWidth");
        PropCategoryManager.categorizeProperty("Style", "fillColor");
        PropCategoryManager.categorizeProperty("Style", "lineColor");
        PropCategoryManager.categorizeProperty("Style", "filled");
    }
}

