/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.tigris.gef.presentation.Fig;

public class FigCircle
extends Fig {
    private static final long serialVersionUID = 7376986113799307733L;
    public static final double CIRCLE_ADJUST_RADIUS = 0.1;
    protected boolean _isDashed = false;

    public FigCircle(int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
    }

    public FigCircle(int n2, int n3, int n4, int n5, Color color, Color color2) {
        super(n2, n3, n4, n5, color, color2);
    }

    public FigCircle(int n2, int n3, int n4, int n5, boolean bl2) {
        super(n2, n3, n4, n5);
        this.resizable = bl2;
    }

    public FigCircle(int n2, int n3, int n4, int n5, boolean bl2, Color color, Color color2) {
        super(n2, n3, n4, n5, color, color2);
        this.resizable = bl2;
    }

    @Override
    public void paint(Graphics graphics) {
        int n2 = this.getLineWidth();
        if (graphics instanceof Graphics2D) {
            this.paint((Graphics2D)graphics);
            return;
        }
        if (this._filled && this._fillColor != null) {
            if (n2 > 0 && this._lineColor != null) {
                graphics.setColor(this._lineColor);
                graphics.fillOval(this._x, this._y, this._w, this._h);
            }
            if (!this._fillColor.equals(this._lineColor)) {
                graphics.setColor(this._fillColor);
                graphics.fillOval(this._x + n2, this._y + n2, this._w - (n2 << 1), this._h - (n2 << 1));
                return;
            }
        } else if (n2 > 0 && this._lineColor != null) {
            graphics.setColor(this._lineColor);
            graphics.drawOval(this._x, this._y, this._w, this._h);
        }
    }

    private void paint(Graphics2D graphics2D) {
        int n2 = this.getLineWidth();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(this.getDefaultStroke(n2));
        if (this._filled && this._fillColor != null) {
            FigCircle figCircle = this;
            graphics2D.setPaint(figCircle.getDefaultPaint(figCircle._fillColor, this._lineColor, this._x, this._y, this._w, this._h));
            graphics2D.fill(new Ellipse2D.Float(this._x + n2, this._y + n2, this._w - 2 * n2, this._h - 2 * n2));
        }
        if (n2 > 0 && this._lineColor != null) {
            graphics2D.setPaint(this._lineColor);
            graphics2D.draw(new Ellipse2D.Float(this._x + n2 / 2, this._y + n2 / 2, this._w - n2, this._h - n2));
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        stringBuffer.append("<ellipse id='").append(this.getId()).append("'");
        this.appendSvgStyle(stringBuffer);
        stringBuffer.append("cx='").append(this.getCenter().x).append("'cy='").append(this.getCenter().y).append("'rx='").append(this.getWidth() / 2).append("'ry='").append(this.getHeight() / 2).append("' />");
    }

    @Override
    public boolean contains(int n2, int n3) {
        if (!super.contains(n2, n3)) {
            return false;
        }
        double d2 = (double)(this._x + this._w / 2 - n2) * 2.0 / (double)this._w;
        double d3 = (double)(this._y + this._h / 2 - n3) * 2.0 / (double)this._h;
        double d4 = d2;
        double d5 = d3;
        return d4 * d4 + d5 * d5 <= 1.01;
    }

    @Override
    public Point connectionPoint(Point point) {
        double d2 = this._w / 2;
        double d3 = this._h / 2;
        double d4 = (double)point.x - ((double)this._x + d2);
        double d5 = (double)point.y - ((double)this._y + d3);
        double d6 = d3;
        double d7 = d2;
        double d8 = d6 * d6 * d4 * d4 + d7 * d7 * d5 * d5;
        double d9 = d2 * d3 / Math.sqrt(d8);
        return new Point((int)(d9 * d4 + (double)this._x + d2), (int)(d9 * d5 + (double)this._y + d3));
    }
}

