/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.PathConv;
import org.tigris.gef.base.PathItemPlacementStrategy;
import org.tigris.gef.di.GraphEdge;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.ArrowHeadNone;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge$1;
import org.tigris.gef.presentation.FigEdge$PathItem;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.ui.Highlightable;
import org.tigris.gef.undo.UndoManager;

public abstract class FigEdge
extends Fig
implements GraphEdge,
Highlightable {
    private Fig sourcePortFig;
    private Fig destPortFig;
    private FigNode sourceFigNode;
    private FigNode destFigNode;
    private Fig routeFig;
    protected boolean _useNearest = false;
    protected boolean _highlight = false;
    protected ArrowHead _arrowHeadStart = ArrowHeadNone.TheInstance;
    protected ArrowHead _arrowHeadEnd = ArrowHeadNone.TheInstance;
    @Deprecated
    protected Vector<FigEdge$PathItem> _pathItems = new Vector();

    public FigEdge() {
        FigEdge figEdge = this;
        figEdge.setFig(figEdge.makeEdgeFig());
    }

    public FigEdge(Fig fig, Fig fig2, FigNode figNode, FigNode figNode2, Object object) {
        this.setSourcePortFig(fig);
        this.setDestPortFig(fig2);
        this.setSourceFigNode(figNode);
        this.setDestFigNode(figNode2);
        this.setOwner(object);
        FigEdge figEdge = this;
        figEdge.setFig(figEdge.makeEdgeFig());
        this.routeFig.setGroup(this);
        this.routeFig.setLayer(this.getLayer());
    }

    public void addPathItem(Fig fig, PathConv pathConv) {
        this._pathItems.addElement(new FigEdge$PathItem(this, fig, pathConv));
        fig.setGroup(this);
    }

    @Override
    public void calcBounds() {
        this.routeFig.calcBounds();
        Rectangle rectangle = this.routeFig.getBounds();
        Point point = new Point();
        int n2 = this._pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable = this._pathItems.elementAt(i2);
            PathConv pathConv = ((FigEdge$PathItem)serializable).getPath();
            serializable = ((FigEdge$PathItem)serializable).getFig();
            int n3 = ((Fig)serializable).getX();
            int n4 = ((Fig)serializable).getY();
            int n5 = ((Fig)serializable).getWidth() / 2;
            int n6 = ((Fig)serializable).getHeight() / 2;
            pathConv.stuffPoint(point);
            if (n3 != point.x || n4 != point.y) {
                ((Fig)serializable).damage();
                ((Fig)serializable).setLocation(point.x - n5, point.y - n6);
            }
            rectangle.add(((Fig)serializable).getBounds());
        }
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height;
    }

    @Override
    public final void cleanUp() {
        this.routeFig.cleanUp();
    }

    public final void computeRoute() {
        if (UndoManager.getInstance().isGenerateMementos()) {
            FigEdge$1 figEdge$1 = new FigEdge$1(this);
            UndoManager.getInstance().addMemento(figEdge$1);
        }
        this.computeRouteImpl();
    }

    public abstract void computeRouteImpl();

    @Override
    public final boolean contains(int n2, int n3) {
        if (this.routeFig.contains(n2, n3)) {
            return true;
        }
        int n4 = this._pathItems.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this._pathItems.elementAt(i2).getFig().contains(n2, n3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeFromDiagram() {
        if (this.sourceFigNode != null) {
            this.sourceFigNode.removeFigEdge(this);
        }
        if (this.destFigNode != null) {
            this.destFigNode.removeFigEdge(this);
        }
        super.removeFromDiagram();
    }

    public final boolean getBetweenNearestPoints() {
        return this._useNearest;
    }

    @Override
    public final Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        this.routeFig.getBounds(rectangle);
        int n2 = this._pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this._pathItems.get(i2).getFig();
            rectangle.add(fig.getBounds());
        }
        return rectangle;
    }

    @Override
    public boolean getDashed() {
        return this.routeFig.getDashed();
    }

    public final ArrowHead getDestArrowHead() {
        return this._arrowHeadEnd;
    }

    public final FigNode getDestFigNode() {
        return this.destFigNode;
    }

    public Fig getDestPortFig() {
        return this.destPortFig;
    }

    public final Fig getFig() {
        return this.routeFig;
    }

    @Override
    public final Point getFirstPoint() {
        return this.routeFig.getFirstPoint();
    }

    @Override
    public final boolean getHighlight() {
        return this._highlight;
    }

    @Override
    public final Point getLastPoint() {
        return this.routeFig.getLastPoint();
    }

    @Override
    public final Color getLineColor() {
        return this.routeFig.getLineColor();
    }

    @Override
    public final boolean hasFillColor() {
        return false;
    }

    @Override
    public final int getLineWidth() {
        return this.routeFig.getLineWidth();
    }

    @Override
    public final int getNumPoints() {
        return this.routeFig.getNumPoints();
    }

    public final Fig getPathItem(PathConv pathConv) {
        return null;
    }

    public final Fig getPathItemFig(FigEdge$PathItem figEdge$PathItem) {
        return figEdge$PathItem.getFig();
    }

    public final Vector getPathItemFigs() {
        Vector<Fig> vector = new Vector<Fig>();
        for (int i2 = 0; i2 < this._pathItems.size(); ++i2) {
            FigEdge figEdge = this;
            vector.add(figEdge.getPathItemFig(figEdge._pathItems.elementAt(i2)));
        }
        return vector;
    }

    public PathItemPlacementStrategy getPathItemPlacementStrategy(Fig fig) {
        for (FigEdge$PathItem figEdge$PathItem : this._pathItems) {
            Fig fig2 = this.getPathItemFig(figEdge$PathItem);
            if (!fig.equals(fig2)) continue;
            return figEdge$PathItem.getPathItemPlacementStrategy();
        }
        return null;
    }

    public final Vector getPathItemsRaw() {
        return this._pathItems;
    }

    private List<FigEdge$PathItem> getPathItems() {
        return new ArrayList<FigEdge$PathItem>(this._pathItems);
    }

    public List<PathItemPlacementStrategy> getPathItemStrategies() {
        ArrayList<PathItemPlacementStrategy> arrayList = new ArrayList<PathItemPlacementStrategy>();
        for (FigEdge$PathItem figEdge$PathItem : this.getPathItems()) {
            arrayList.add(figEdge$PathItem.getPath());
        }
        return arrayList;
    }

    @Override
    public final int getPerimeterLength() {
        return this.routeFig.getPerimeterLength();
    }

    @Override
    public final Point[] getPoints() {
        return this.routeFig.getPoints();
    }

    @Override
    public final Point getPoint(int n2) {
        return this.routeFig.getPoint(n2);
    }

    @Override
    public String getPrivateData() {
        Fig fig = this.getSourcePortFig();
        Fig fig2 = this.getDestPortFig();
        FigNode figNode = this.getSourceFigNode();
        FigNode figNode2 = this.getDestFigNode();
        String string = "";
        if (fig != null) {
            string = string + "sourcePortFig=\"" + fig.getId() + "\" ";
        }
        if (fig2 != null) {
            string = string + "destPortFig=\"" + fig2.getId() + "\" ";
        }
        if (figNode != null) {
            string = string + "sourceFigNode=\"" + figNode.getId() + "\" ";
        }
        if (figNode2 != null) {
            string = string + "destFigNode=\"" + figNode2.getId() + "\" ";
        }
        return string;
    }

    public final ArrowHead getSourceArrowHead() {
        return this._arrowHeadStart;
    }

    public final FigNode getSourceFigNode() {
        return this.sourceFigNode;
    }

    @Override
    public final GraphNode getSourceGraphNode() {
        return this.sourceFigNode;
    }

    @Override
    public final GraphNode getDestGraphNode() {
        return this.destFigNode;
    }

    public Fig getSourcePortFig() {
        return this.sourcePortFig;
    }

    @Override
    public final int[] getXs() {
        return this.routeFig.getXs();
    }

    @Override
    public final int[] getYs() {
        return this.routeFig.getYs();
    }

    @Override
    public boolean hit(Rectangle rectangle) {
        if (this.routeFig.hit(rectangle)) {
            return true;
        }
        int n2 = this._pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fig fig = this._pathItems.elementAt(i2).getFig();
            if (!fig.isAnnotation() || !fig.hit(rectangle)) continue;
            return true;
        }
        return false;
    }

    public final Fig hitFig(Rectangle rectangle) {
        Enumeration<FigEdge$PathItem> enumeration = this._pathItems.elements();
        Fig fig = null;
        if (this.routeFig.hit(rectangle)) {
            fig = this.routeFig;
        }
        while (enumeration.hasMoreElements()) {
            Fig fig2 = enumeration.nextElement().getFig();
            if (!fig2.hit(rectangle)) continue;
            fig = fig2;
        }
        return fig;
    }

    @Override
    public final boolean intersects(Rectangle rectangle) {
        if (this.routeFig.intersectsPerimeter(rectangle)) {
            return true;
        }
        int n2 = this._pathItems.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this._pathItems.elementAt(i2).getFig().intersects(rectangle)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean isReshapable() {
        return this.routeFig.isReshapable();
    }

    @Override
    public final boolean isResizable() {
        return this.routeFig.isResizable();
    }

    @Override
    public final boolean isRotatable() {
        return this.routeFig.isRotatable();
    }

    protected abstract Fig makeEdgeFig();

    @Override
    public void paint(Graphics graphics) {
        this.routeFig.paint(graphics);
        this.paintArrowHeads(graphics);
        this.paintPathItems(graphics);
    }

    @Override
    public void appendSvg(StringBuffer stringBuffer) {
        this.routeFig.appendSvg(stringBuffer);
        this.appendSvgPathItems(stringBuffer);
    }

    protected final void paintArrowHeads(Object object) {
        this._arrowHeadStart.paintAtHead(object, this.routeFig);
        this._arrowHeadEnd.paintAtTail(object, this.routeFig);
    }

    public final void paintHighlightLine(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.setColor(Globals.getPrefs().getHighlightColor());
        double d2 = n4 - n2;
        double d3 = n5 - n3;
        double d4 = d2;
        double d5 = d3;
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        if (d6 == 0.0) {
            return;
        }
        double d7 = d3 / d6;
        double d8 = -d2 / d6;
        for (double d9 = 2.0; d9 < 5.0; d9 += 0.27) {
            int n6 = (int)((double)n2 + d9 * d7);
            int n7 = (int)((double)n3 + d9 * d8);
            int n8 = (int)((double)n4 + d9 * d7);
            int n9 = (int)((double)n5 + d9 * d8);
            graphics.drawLine(n6, n7, n8, n9);
        }
    }

    protected final void paintPathItems(Graphics graphics) {
        Vector vector = this.getPathItemsRaw();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((FigEdge$PathItem)vector.elementAt(i2)).getFig().paint(graphics);
        }
    }

    protected final void appendSvgPathItems(StringBuffer stringBuffer) {
        Vector vector = this.getPathItemsRaw();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((FigEdge$PathItem)vector.elementAt(i2)).getFig().appendSvg(stringBuffer);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("disposed") && object == this.getOwner()) {
            this.removeFromDiagram();
        }
        if (string.equals("highlight") && object == this.getOwner()) {
            this._highlight = (Boolean)propertyChangeEvent.getNewValue();
            this.damage();
        }
    }

    public final void removePathItem(FigEdge$PathItem figEdge$PathItem) {
        this._pathItems.removeElement(figEdge$PathItem);
        figEdge$PathItem.getFig().setGroup(null);
    }

    public final void removePathItem(Fig fig) {
        for (int i2 = 0; i2 < this._pathItems.size(); ++i2) {
            FigEdge$PathItem figEdge$PathItem = this._pathItems.elementAt(i2);
            if (figEdge$PathItem.getFig() != fig) continue;
            this.removePathItem(figEdge$PathItem);
            return;
        }
    }

    public final void setBetweenNearestPoints(boolean bl2) {
        this._useNearest = bl2;
    }

    @Override
    public final void setDashed(boolean bl2) {
        this.routeFig.setDashed(bl2);
    }

    public void setDestArrowHead(ArrowHead arrowHead) {
        this._arrowHeadEnd = arrowHead;
    }

    public void setDestFigNode(FigNode figNode) {
        try {
            if (this.destFigNode != null) {
                this.destFigNode.removeFigEdge(this);
            }
            this.destFigNode = figNode;
            figNode.addFigEdge(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final void setDestPortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A destination port must be supplied");
        }
        this.destPortFig = fig;
    }

    public void setFig(Fig fig) {
        if (this.routeFig != null && this.routeFig.getGroup() == this) {
            this.routeFig.setGroup(null);
        }
        this.routeFig = fig;
        this.routeFig.setGroup(this);
        this.routeFig.setLayer(this.getLayer());
    }

    @Override
    public final void setHighlight(boolean bl2) {
        this._highlight = bl2;
        this.damage();
    }

    @Override
    public void setLineColor(Color color) {
        this.routeFig.setLineColor(color);
        FigEdge figEdge = this;
        figEdge.setArrowColor(figEdge.getSourceArrowHead(), color);
        FigEdge figEdge2 = this;
        figEdge2.setArrowColor(figEdge2.getDestArrowHead(), color);
    }

    private void setArrowColor(ArrowHead arrowHead, Color color) {
        if (arrowHead != null) {
            arrowHead.setLineColor(color);
        }
    }

    @Override
    public final void setLineWidth(int n2) {
        this.routeFig.setLineWidth(n2);
    }

    @Override
    public final void setNumPoints(int n2) {
        this.routeFig.setNumPoints(n2);
        this.calcBounds();
    }

    @Override
    public void setOwner(Object object) {
        Object object2 = this.getOwner();
        if (object2 instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object2).removePropertyChangeListener(this);
        } else if (object2 instanceof Highlightable) {
            ((Highlightable)object2).removePropertyChangeListener(this);
        }
        if (object instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object).addPropertyChangeListener(this);
        } else if (object instanceof Highlightable) {
            ((Highlightable)object).addPropertyChangeListener(this);
        }
        super.setOwner(object);
    }

    @Override
    public final void setPoints(Point[] pointArray) {
        this.routeFig.setPoints(pointArray);
        this.calcBounds();
    }

    @Override
    public final void setPoint(int n2, int n3, int n4) {
        this.routeFig.setPoint(n2, n3, n4);
        this.calcBounds();
    }

    @Override
    public void setPoint(Handle handle, int n2, int n3) {
        this.routeFig.setPoint(handle, n2, n3);
        this.calcBounds();
    }

    public void setSourceArrowHead(ArrowHead arrowHead) {
        this._arrowHeadStart = arrowHead;
    }

    public void setSourceFigNode(FigNode figNode) {
        try {
            if (this.sourceFigNode != null) {
                this.sourceFigNode.removeFigEdge(this);
            }
            this.sourceFigNode = figNode;
            figNode.addFigEdge(this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public void setSourceGraphNode(GraphNode graphNode) {
        this.setSourceFigNode((FigNode)graphNode);
    }

    @Override
    public void setDestGraphNode(GraphNode graphNode) {
        this.setDestFigNode((FigNode)graphNode);
    }

    public final void setSourcePortFig(Fig fig) {
        if (fig == null) {
            throw new IllegalArgumentException("A source port must be supplied");
        }
        this.sourcePortFig = fig;
    }

    @Override
    public final void setXs(int[] nArray) {
        this.routeFig.setXs(nArray);
        this.calcBounds();
    }

    @Override
    public final void setYs(int[] nArray) {
        this.routeFig.setYs(nArray);
        this.calcBounds();
    }

    @Override
    public final void stuffPointAlongPerimeter(int n2, Point point) {
        this.routeFig.stuffPointAlongPerimeter(n2, point);
    }

    public final void translateEdge(int n2, int n3) {
        this.routeFig.translate(n2, n3);
        this.calcBounds();
    }

    @Override
    public void translateImpl(int n2, int n3) {
        this.routeFig.translate(n2, n3);
        this.calcBounds();
    }

    public final void updatePathItemLocations() {
        this.calcBounds();
    }
}

