/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class FigEdgePoly
extends FigEdge {
    private static final long serialVersionUID = -5534202173807357676L;
    @Deprecated
    protected boolean _initiallyLaidOut;
    private static Handle _TempHandle = new Handle(0);

    @Override
    protected Fig makeEdgeFig() {
        FigPoly figPoly = new FigPoly(Color.black);
        figPoly.setRectilinear(false);
        figPoly.setFixedHandles(1);
        figPoly.setFilled(false);
        return figPoly;
    }

    @Override
    public void computeRouteImpl() {
        if (!this._initiallyLaidOut) {
            this.layoutEdge();
            this._initiallyLaidOut = true;
        }
        FigPoly figPoly = (FigPoly)this.getFig();
        Fig fig = this.getSourcePortFig();
        Fig fig2 = this.getDestPortFig();
        Point point = fig.getCenter();
        Point point2 = fig2.getCenter();
        if (this._useNearest) {
            if (figPoly.getNumPoints() == 2) {
                fig.connectionPoint(figPoly.getPoint(1));
                FigPoly figPoly2 = figPoly;
                point2 = fig2.connectionPoint(figPoly2.getPoint(figPoly2.getNumPoints() - 2));
                point = fig.connectionPoint(point2);
                point2 = fig2.connectionPoint(point);
            } else {
                point = fig.connectionPoint(figPoly.getPoint(1));
                FigPoly figPoly3 = figPoly;
                point2 = fig2.connectionPoint(figPoly3.getPoint(figPoly3.getNumPoints() - 2));
            }
        }
        this.setEndPoints(point, point2);
        this.calcBounds();
    }

    protected void layoutEdge() {
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        Fig fig = this.getSourcePortFig();
        Fig fig2 = this.getDestPortFig();
        if (fig == null || fig2 == null) {
            throw new IllegalStateException("Both the source port and dest port fig must be defined on a " + this.getClass().getName() + " before the edge can be layed out");
        }
        Point point = fig.getCenter();
        Point point2 = fig2.getCenter();
        if (this._useNearest) {
            int n2 = point.x - point2.x;
            int n3 = point.y - point2.y;
            point.x = (int)((double)point.x - 0.1 * (double)n2);
            point.y = (int)((double)point.y - 0.1 * (double)n3);
            point2.x = (int)((double)point2.x + 0.1 * (double)n2);
            point2.y = (int)((double)point2.y + 0.1 * (double)n3);
            point = fig.connectionPoint(point2);
            point2 = fig2.connectionPoint(point);
            point = fig.connectionPoint(point2);
            point2 = fig2.connectionPoint(point);
        }
        nArray[0] = point.x;
        nArray2[0] = point.y;
        nArray[1] = point2.x;
        nArray2[1] = point2.y;
        Polygon polygon = new Polygon(nArray, nArray2, 2);
        ((FigPoly)this.getFig()).setPolygon(polygon);
    }

    protected Point routingRectPoint(Point point, Rectangle rectangle, int n2) {
        switch (n2) {
            case -1: {
                return new Point(point.x, rectangle.y);
            }
            case 2: {
                return new Point(rectangle.x, point.y);
            }
            case 1: {
                return new Point(point.x, rectangle.y + rectangle.height);
            }
            case -2: {
                return new Point(rectangle.x + rectangle.width, point.y);
            }
        }
        System.out.println("error, undefined sector!");
        return point;
    }

    protected int tryRoute(int n2, int n3, int n4, int[] nArray, int[] nArray2, Rectangle rectangle, Rectangle rectangle2, int n5, int n6) {
        if (n4 > 12) {
            return 0;
        }
        int n7 = nArray[n4 - 1];
        int n8 = nArray2[n4 - 1];
        if ((n7 == n2 || n8 == n3) && this.segOK(n7, n8, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n2;
            nArray2[n4++] = n3;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 1;
        }
        if (this.segOK(n7, n8, n7, n3, rectangle, rectangle2) && this.segOK(n7, n3, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n7;
            nArray2[n4++] = n3;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 2;
        }
        if (this.segOK(n7, n8, n2, n8, rectangle, rectangle2) && this.segOK(n2, n8, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n2;
            nArray2[n4++] = n8;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 2;
        }
        Point point = this.findAvoidPt(n7, n8, n2, n3, rectangle, rectangle2);
        if ((n5 == 1 || n5 == -1 || n8 == point.y) && n7 != point.x) {
            nArray[n4] = point.x;
            nArray2[n4++] = n8;
            return this.tryRoute(n2, n3, n4, nArray, nArray2, rectangle, rectangle2, n5, n6) + 1;
        }
        if ((n5 == 2 || n5 == -2 || n7 == point.x) && n8 != point.y) {
            nArray[n4] = n7;
            nArray2[n4++] = point.y;
            return this.tryRoute(n2, n3, n4, nArray, nArray2, rectangle, rectangle2, n5, n6) + 1;
        }
        return 0;
    }

    protected Point findAvoidPt(int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point(n2, n3);
        point.x = rectangle.x + rectangle.width < rectangle2.x ? rectangle2.x : (rectangle2.x + rectangle2.width < rectangle.x ? rectangle.x : Math.min(rectangle.x, rectangle2.x));
        point.y = rectangle.y + rectangle.height < rectangle2.y ? rectangle2.y : (rectangle2.y + rectangle2.height < rectangle.y ? rectangle.y : Math.min(rectangle.y, rectangle2.y));
        return point;
    }

    protected boolean segOK(int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2) {
        int n6 = Math.min(n2, n4);
        int n7 = Math.max(n2, n4);
        int n8 = Math.min(n3, n5);
        int n9 = Math.max(n3, n5);
        int n10 = rectangle.x + rectangle.width;
        int n11 = rectangle.y + rectangle.height;
        if (n2 == n4 && n2 > rectangle.x && n2 < n10 && (n8 < rectangle.y && n9 > rectangle.y || n8 < n11 && n9 > n11)) {
            return false;
        }
        if (n3 == n5 && n3 > rectangle.y && n3 < n11 && (n6 < rectangle.x && n7 > rectangle.x || n6 < n10 && n7 > n10)) {
            return false;
        }
        n10 = rectangle2.x + rectangle2.width;
        n11 = rectangle2.y + rectangle2.height;
        if (n2 == n4 && n2 > rectangle2.x && n2 < n10 && (n8 < rectangle2.y && n9 > rectangle2.y || n8 < n11 && n9 > n11)) {
            return false;
        }
        return n3 != n5 || n3 <= rectangle2.y || n3 >= n11 || (n6 >= rectangle2.x || n7 <= rectangle2.x) && (n6 >= n10 || n7 <= n10);
    }

    public void moveVertex(Handle handle, int n2, int n3, boolean n4) {
        int n5 = handle.index;
        n4 = this.getFig().getNumPoints();
        FigPoly figPoly = (FigPoly)this.getFig();
        if (!figPoly.getRectilinear()) {
            if (figPoly.isComplete()) {
                if (n5 == 0) {
                    if (!(figPoly._xpoints[n5 + 1] != n2 || figPoly._ypoints[n5 + 1] != n3 || figPoly._isSelfLoop && figPoly._npoints <= 4)) {
                        figPoly.removePoint(n5 + 1);
                    }
                } else if (!(n5 != n4 - 1 || figPoly._xpoints[n5 - 1] != n2 || figPoly._ypoints[n5 - 1] != n3 || figPoly._isSelfLoop && figPoly._npoints <= 4)) {
                    figPoly.removePoint(n5 - 1);
                }
                if (n4 > 2) {
                    Point point = new Point(n2, n3);
                    Cloneable cloneable = this.getSourcePortFig();
                    Fig fig = this.getDestPortFig();
                    cloneable.getCenter();
                    fig.getCenter();
                    if (n5 == 1 && n4 == 3) {
                        cloneable = cloneable.connectionPoint(point);
                        point = fig.connectionPoint(point);
                        figPoly.moveVertex(new Handle(0), ((Point)cloneable).x, ((Point)cloneable).y, true);
                        figPoly.moveVertex(new Handle(n4 - 1), point.x, point.y, true);
                        this.calcBounds();
                    } else if (n5 == 1) {
                        cloneable = cloneable.connectionPoint(point);
                        figPoly.moveVertex(new Handle(0), ((Point)cloneable).x, ((Point)cloneable).y, true);
                        this.calcBounds();
                    } else if (n5 == n4 - 2) {
                        point = fig.connectionPoint(point);
                        figPoly.moveVertex(new Handle(n4 - 1), point.x, point.y, true);
                        this.calcBounds();
                    }
                }
            }
            figPoly._xpoints[n5] = n2;
            figPoly._ypoints[n5] = n3;
        }
    }

    @Override
    public void setPoint(Handle handle, int n2, int n3) {
        this.moveVertex(handle, n2, n3, false);
        this.calcBounds();
    }

    public void setPolygon(Polygon polygon) {
        ((FigPoly)this.getFig()).setPolygon(polygon);
        this.calcBounds();
    }

    public Polygon getPolygon() {
        return ((FigPoly)this.getFig()).getPolygon();
    }

    @Override
    public void insertPoint(int n2, int n3, int n4) {
        ((FigPoly)this.getFig()).insertPoint(n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEndPoints(Point point, Point point2) {
        FigPoly figPoly = (FigPoly)this.getFig();
        while (figPoly._npoints < 2) {
            figPoly.addPoint(point);
        }
        Handle handle = _TempHandle;
        synchronized (handle) {
            FigEdgePoly._TempHandle.index = 0;
            this.moveVertex(_TempHandle, point.x, point.y, true);
            FigEdgePoly._TempHandle.index = figPoly._npoints - 1;
            this.moveVertex(_TempHandle, point2.x, point2.y, true);
            return;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._highlight) {
            Object object = (FigPoly)this.getFig();
            int n2 = ((FigPoly)object).getNumPoints();
            int[] nArray = ((FigPoly)object).getXs();
            object = ((FigPoly)object).getYs();
            for (int i2 = 1; i2 < n2; ++i2) {
                this.paintHighlightLine(graphics, nArray[i2 - 1], (int)object[i2 - 1], nArray[i2], (int)object[i2]);
            }
        }
    }

    public void setInitiallyLaidOut(boolean bl2) {
        this._initiallyLaidOut = bl2;
    }
}

