/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPoly;

public class FigEdgeRectiline2
extends FigEdge {
    private static final long serialVersionUID = 82233091447851020L;
    protected boolean _initiallyLaidOut = false;

    @Override
    protected Fig makeEdgeFig() {
        FigPoly figPoly = new FigPoly(Color.black);
        figPoly.setRectilinear(true);
        figPoly.setFixedHandles(1);
        figPoly.setFilled(false);
        return figPoly;
    }

    @Override
    public void computeRouteImpl() {
        if (!this._initiallyLaidOut) {
            this.layoutEdge();
            this._initiallyLaidOut = true;
        }
        FigPoly figPoly = (FigPoly)this.getFig();
        Cloneable cloneable = this.getSourcePortFig();
        Cloneable cloneable2 = this.getDestPortFig();
        if (this._useNearest) {
            cloneable = cloneable.connectionPoint(figPoly.getPoint(1));
            FigPoly figPoly2 = figPoly;
            cloneable2 = ((Fig)cloneable2).connectionPoint(figPoly2.getPoint(figPoly2.getNumPoints() - 2));
        } else {
            cloneable = cloneable.getCenter();
            cloneable2 = ((Fig)cloneable2).getCenter();
        }
        figPoly.setEndPoints((Point)cloneable, (Point)cloneable2);
        this.calcBounds();
    }

    protected void layoutEdge() {
        int n2 = 0;
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        Fig fig = this.getSourcePortFig();
        Fig fig2 = this.getDestPortFig();
        Point point = fig.getCenter();
        Point point2 = fig2.getCenter();
        if (this._useNearest) {
            point = fig.connectionPoint(point2);
            point2 = fig2.connectionPoint(point);
            point = fig.connectionPoint(point2);
            point2 = fig2.connectionPoint(point);
        }
        Rectangle rectangle = this.getSourceFigNode().routingRect();
        Rectangle rectangle2 = this.getDestFigNode().routingRect();
        int n3 = this.getSourceFigNode().getPortSector(fig);
        int n4 = this.getDestFigNode().getPortSector(fig2);
        Point point3 = this.routingRectPoint(point, rectangle, n3);
        Point point4 = this.routingRectPoint(point2, rectangle2, n4);
        if (n3 == 1 || n3 == -1) {
            nArray[0] = point.x;
            ++n2;
            nArray2[0] = point.y;
        }
        nArray[n2] = point.x;
        nArray2[n2++] = point.y;
        nArray[n2] = point3.x;
        nArray2[n2++] = point3.y;
        n2 += this.tryRoute(point4.x, point4.y, n2, nArray, nArray2, rectangle, rectangle2, n3, n4);
        nArray[n2] = point4.x;
        nArray2[n2++] = point4.y;
        nArray[n2] = point2.x;
        nArray2[n2++] = point2.y;
        Polygon polygon = new Polygon(nArray, nArray2, n2);
        ((FigPoly)this.getFig()).setPolygon(polygon);
    }

    protected Point routingRectPoint(Point point, Rectangle rectangle, int n2) {
        switch (n2) {
            case -1: {
                return new Point(point.x, rectangle.y);
            }
            case 2: {
                return new Point(rectangle.x, point.y);
            }
            case 1: {
                return new Point(point.x, rectangle.y + rectangle.height);
            }
            case -2: {
                return new Point(rectangle.x + rectangle.width, point.y);
            }
        }
        System.out.println("error, undefined sector!");
        return point;
    }

    protected int tryRoute(int n2, int n3, int n4, int[] nArray, int[] nArray2, Rectangle rectangle, Rectangle rectangle2, int n5, int n6) {
        if (n4 > 12) {
            return 0;
        }
        int n7 = nArray[n4 - 1];
        int n8 = nArray2[n4 - 1];
        if ((n7 == n2 || n8 == n3) && this.segOK(n7, n8, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n2;
            nArray2[n4++] = n3;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 1;
        }
        if (this.segOK(n7, n8, n7, n3, rectangle, rectangle2) && this.segOK(n7, n3, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n7;
            nArray2[n4++] = n3;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 2;
        }
        if (this.segOK(n7, n8, n2, n8, rectangle, rectangle2) && this.segOK(n2, n8, n2, n3, rectangle, rectangle2)) {
            nArray[n4] = n2;
            nArray2[n4++] = n8;
            nArray[n4] = n2;
            nArray2[n4] = n3;
            return 2;
        }
        Point point = this.findAvoidPt(n7, n8, n2, n3, rectangle, rectangle2);
        if ((n5 == 1 || n5 == -1 || n8 == point.y) && n7 != point.x) {
            nArray[n4] = point.x;
            nArray2[n4++] = n8;
            return this.tryRoute(n2, n3, n4, nArray, nArray2, rectangle, rectangle2, n5, n6) + 1;
        }
        if ((n5 == 2 || n5 == -2 || n7 == point.x) && n8 != point.y) {
            nArray[n4] = n7;
            nArray2[n4++] = point.y;
            return this.tryRoute(n2, n3, n4, nArray, nArray2, rectangle, rectangle2, n5, n6) + 1;
        }
        return 0;
    }

    protected Point findAvoidPt(int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2) {
        Point point = new Point(n2, n3);
        point.x = rectangle.x + rectangle.width < rectangle2.x ? rectangle2.x : (rectangle2.x + rectangle2.width < rectangle.x ? rectangle.x : Math.min(rectangle.x, rectangle2.x));
        point.y = rectangle.y + rectangle.height < rectangle2.y ? rectangle2.y : (rectangle2.y + rectangle2.height < rectangle.y ? rectangle.y : Math.min(rectangle.y, rectangle2.y));
        return point;
    }

    protected boolean segOK(int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2) {
        int n6 = Math.min(n2, n4);
        int n7 = Math.max(n2, n4);
        int n8 = Math.min(n3, n5);
        int n9 = Math.max(n3, n5);
        int n10 = rectangle.x + rectangle.width;
        int n11 = rectangle.y + rectangle.height;
        if (n2 == n4 && n2 > rectangle.x && n2 < n10 && (n8 < rectangle.y && n9 > rectangle.y || n8 < n11 && n9 > n11)) {
            return false;
        }
        if (n3 == n5 && n3 > rectangle.y && n3 < n11 && (n6 < rectangle.x && n7 > rectangle.x || n6 < n10 && n7 > n10)) {
            return false;
        }
        n10 = rectangle2.x + rectangle2.width;
        n11 = rectangle2.y + rectangle2.height;
        if (n2 == n4 && n2 > rectangle2.x && n2 < n10 && (n8 < rectangle2.y && n9 > rectangle2.y || n8 < n11 && n9 > n11)) {
            return false;
        }
        return n3 != n5 || n3 <= rectangle2.y || n3 >= n11 || (n6 >= rectangle2.x || n7 <= rectangle2.x) && (n6 >= n10 || n7 <= n10);
    }
}

