/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.BitSet;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class FigSpline
extends FigPoly {
    private static final long serialVersionUID = 8105448783671550399L;
    protected int[] _xknots = new int[5];
    protected int[] _yknots = new int[5];
    protected int _nknots;
    protected Polygon _curve;
    protected int _threshold = 5;
    protected int SPLINE_THRESH = 2;
    protected int ARR_WIDTH = 5;
    protected int ARR_HEIGHT = 16;
    protected double _junc_t;
    protected double _delta0;
    protected double _delta1;
    protected double _denom;
    protected double _d_curve_length;
    protected int _juncX;
    protected int _juncY;
    protected int _pattern = -2004318072;
    protected BitSet _style = new BitSet(32);

    public FigSpline() {
    }

    public FigSpline(int n2, int n3) {
        this.addPoint(n2, n3);
    }

    public FigSpline(Color color) {
        super(color);
    }

    public FigSpline(Color color, Color color2) {
        super(color, color2);
    }

    @Override
    public void addPoint(int n2, int n3) {
        super.addPoint(n2, n3);
        this.setCount();
        this.setSpline();
    }

    @Override
    public void appendTwoPoints() {
        super.appendTwoPoints();
        this.setCount();
        this.setSpline();
    }

    @Override
    public void cleanUp() {
    }

    private double dist(int n2, int n3, int n4, int n5) {
        double d2 = n2 - n4;
        double d3 = n3 - n5;
        double d4 = d2;
        double d5 = d3;
        return Math.sqrt(d4 * d4 + d5 * d5);
    }

    @Override
    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] nArray = new int[this._npoints << 1];
            System.arraycopy(this._xpoints, 0, nArray, 0, this._npoints);
            this._xpoints = nArray;
            nArray = new int[this._npoints << 1];
            System.arraycopy(this._ypoints, 0, nArray, 0, this._npoints);
            this._ypoints = nArray;
            nArray = new int[(this._npoints << 2) - 1];
            System.arraycopy(this._xknots, 0, nArray, 0, this._nknots);
            this._xknots = nArray;
            nArray = new int[(this._npoints << 2) - 1];
            System.arraycopy(this._yknots, 0, nArray, 0, this._nknots);
            this._yknots = nArray;
        }
    }

    @Override
    public void insertPoint(int n2, int n3, int n4) {
        super.insertPoint(n2, n3, n4);
        this.setCount();
        this.setSpline();
    }

    @Override
    public void moveVertex(Handle handle, int n2, int n3, boolean bl2) {
        super.moveVertex(handle, n2, n3, bl2);
        this.setSpline();
    }

    @Override
    public void paint(Graphics graphics) {
        if (this._npoints == 2) {
            graphics.setColor(this._lineColor);
            graphics.drawLine(this._xknots[0], this._yknots[0], this._xknots[1], this._yknots[1]);
            return;
        }
        int n2 = this._npoints - 2;
        this._curve = new Polygon();
        graphics.setColor(this._lineColor);
        for (int i2 = 0; i2 <= n2 - 1; ++i2) {
            this.drawBezier(graphics, this._filled, this._fillColor, this._curve, this._xknots[2 * i2], this._yknots[2 * i2], this._xknots[2 * i2 + 1], this._yknots[2 * i2 + 1], this._xknots[2 * i2 + 2], this._yknots[2 * i2 + 2]);
        }
        if (this._filled) {
            graphics.setColor(this._fillColor);
            graphics.fillPolygon(this._curve);
            graphics.setColor(this._lineColor);
            graphics.drawPolyline(this._curve.xpoints, this._curve.ypoints, this._curve.npoints);
        }
    }

    private void drawBezier(Graphics graphics, boolean bl2, Color color, Polygon polygon, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        while (true) {
            int n9 = (n2 + n4) / 2;
            int n10 = (n3 + n5) / 2;
            int n11 = (n4 + n6) / 2;
            int n12 = (n5 + n7) / 2;
            n4 = (n9 + n11) / 2;
            n5 = (n10 + n12) / 2;
            int n13 = (n2 + n4) / 2;
            int n14 = (n3 + n5) / 2;
            n8 = this.getLineWidth();
            if (Math.abs(n9 - n13) + Math.abs(n10 - n14) > this.SPLINE_THRESH) {
                this.drawBezier(graphics, bl2, color, polygon, n2, n3, n9, n10, n4, n5);
            } else {
                this.drawLine(graphics, n8, n2, n3, n4, n5);
                polygon.addPoint(n4, n5);
            }
            n13 = (n6 + n4) / 2;
            n14 = (n7 + n5) / 2;
            if (Math.abs(n11 - n13) + Math.abs(n12 - n14) <= this.SPLINE_THRESH) break;
            int n15 = n4;
            int n16 = n5;
            n5 = n12;
            n4 = n11;
            n3 = n16;
            n2 = n15;
        }
        this.drawLine(graphics, n8, n4, n5, n6, n7);
        polygon.addPoint(n6, n7);
    }

    private void drawLine(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (graphics instanceof Graphics2D && this.getDashed()) {
            this.drawDashedLine(graphics, n2, n3, n4, n5, n6, 0, this._dashes, this._dashPeriod);
            return;
        }
        graphics.drawLine(n3, n4, n5, n6);
    }

    @Override
    public void prependTwoPoints() {
        super.prependTwoPoints();
        this.setCount();
        this.setSpline();
    }

    @Override
    public void removePoint(int n2) {
        super.removePoint(n2);
        this.setCount();
        this.setSpline();
    }

    protected void setCount() {
        if (this._npoints == 2) {
            this._nknots = 2;
        } else if (this._npoints == 3) {
            this._nknots = 3;
        }
        this._nknots = 2 * this._npoints - 3;
    }

    protected void setJunctionPoint(int n2, int n3, int n4, int n5, int n6, int n7) {
        this._delta0 = this.dist(n2, n3, n4, n5);
        this._delta1 = this.dist(n4, n5, n6, n7);
        this._denom = this._delta0 + this._delta1;
        this._junc_t = this._denom <= (double)this._threshold ? 0.0 : this._delta1 / this._denom;
        this._juncX = (int)(this._junc_t * (double)n4 + (1.0 - this._junc_t) * (double)n6);
        this._juncY = (int)(this._junc_t * (double)n5 + (1.0 - this._junc_t) * (double)n7);
    }

    protected void setSpline() {
        if (this._npoints >= 4) {
            int n2;
            this._xknots[0] = this._xpoints[0];
            this._yknots[0] = this._ypoints[0];
            this._xknots[this._nknots - 1] = this._xpoints[this._npoints - 1];
            this._yknots[this._nknots - 1] = this._ypoints[this._npoints - 1];
            for (n2 = 0; n2 <= this._npoints - 4; ++n2) {
                FigSpline figSpline = this;
                figSpline.setJunctionPoint(figSpline._xpoints[n2], this._ypoints[n2], this._xpoints[n2 + 1], this._ypoints[n2 + 1], this._xpoints[n2 + 2], this._ypoints[n2 + 2]);
                this._xknots[2 * (n2 + 1)] = this._juncX;
                this._yknots[2 * (n2 + 1)] = this._juncY;
            }
            for (n2 = 1; n2 <= this._npoints - 2; ++n2) {
                this._xknots[2 * n2 - 1] = this._xpoints[n2];
                this._yknots[2 * n2 - 1] = this._ypoints[n2];
            }
            return;
        }
        if (this._npoints < 4) {
            for (int i2 = 0; i2 < this._npoints; ++i2) {
                this._xknots[i2] = this._xpoints[i2];
                this._yknots[i2] = this._ypoints[i2];
            }
        }
    }

    @Override
    public void translateImpl(int n2, int n3) {
        super.translateImpl(n2, n3);
        this.setSpline();
    }
}

