/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Point;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.AnnotationLineRemover;
import org.tigris.gef.presentation.AnnotationProperties;
import org.tigris.gef.presentation.AnnotationStrategy;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigLine;

public class NodeAnnotationStrategy
extends AnnotationStrategy {
    private static final long serialVersionUID = -7180345622697075103L;

    @Override
    public Point restoreAnnotationPosition(Fig fig) {
        Fig fig2 = fig.getAnnotationOwner();
        if (!(fig2 instanceof FigEdge) && !(fig2 instanceof FigLine)) {
            AnnotationProperties annotationProperties = (AnnotationProperties)this.annotations.get(fig);
            int n2 = annotationProperties.getOffset();
            float f2 = annotationProperties.getRatio();
            int n3 = fig2.getCenter().x;
            int n4 = fig2.getCenter().y;
            n2 = n3 + n2;
            int n5 = (int)((float)n4 + f2);
            return new Point(n2 - fig.getWidth() / 2, n5 - fig.getHeight() / 2);
        }
        return new Point(1, 1);
    }

    @Override
    public void storeAnnotationPosition(Fig object) {
        Fig fig = ((Fig)object).getAnnotationOwner();
        if (!(fig instanceof FigEdge) && !(fig instanceof FigLine)) {
            Point point = ((Fig)object).getCenter();
            Point point2 = fig.getCenter();
            int n2 = point.x - point2.x;
            float f2 = point.y - point2.y;
            object = (AnnotationProperties)this.annotations.get(object);
            ((AnnotationProperties)object).setOffset(n2, ((AnnotationProperties)object).hasFixedOffset());
            ((AnnotationProperties)object).setRatio(f2, ((AnnotationProperties)object).hasFixedRatio());
        }
    }

    public void drawConnectingLine(Fig fig) {
        if (this.getAnnotationProperties(fig).getLineVisibilityDuration() == 0) {
            return;
        }
        Fig fig2 = fig.getAnnotationOwner();
        FigLine figLine = ((AnnotationProperties)this.annotations.get(fig)).getConnectingLine();
        figLine.setShape(fig.getCenter(), fig2.getCenter());
        figLine.setLineColor(Color.red);
        figLine.setFillColor(Color.red);
        figLine.setDashed(true);
        if (!Globals.curEditor().getLayerManager().getContents().contains(figLine)) {
            Globals.curEditor().add(figLine);
        }
        Globals.curEditor().getLayerManager().bringToFront(fig);
        Globals.curEditor().getLayerManager().sendToBack(figLine);
        figLine.damage();
        fig.damage();
        AnnotationLineRemover.instance().removeLineIn(this.getAnnotationProperties(fig).getLineVisibilityDuration(), fig);
    }

    @Override
    public void translateAnnotations(Fig object) {
        object = this.annotations.keys();
        while (object.hasMoreElements()) {
            Fig fig = (Fig)object.nextElement();
            fig.setLocation(this.restoreAnnotationPosition(fig));
            this.drawConnectingLine(fig);
            fig.endTrans();
            fig.damage();
        }
    }
}

