/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import org.tigris.gef.properties.ui.ColorPickerGrid;

public class ColorEditor
extends JPanel
implements PropertyEditor {
    public Color _color = Color.white;
    private Vector listeners;

    public ColorEditor() {
        this.setLayout(null);
        ColorEditor colorEditor = this;
        colorEditor.setSize(colorEditor.getInsets().left + this.getInsets().right + 20, this.getInsets().top + this.getInsets().bottom + 20);
        this.setForeground(Color.lightGray);
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Color)) {
            return;
        }
        this._color = (Color)object;
        this.repaint();
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this._color;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
        graphics.setColor((Color)this.getValue());
        graphics.fill3DRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, true);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintValue(graphics, this.getBounds());
    }

    @Override
    public String getJavaInitializationString() {
        this.getValue();
        return "new Color(" + this.getAsText() + ")";
    }

    @Override
    public String getAsText() {
        return this._color.getRed() + ", " + this._color.getBlue() + ", " + this._color.getGreen();
    }

    @Override
    public void setAsText(String string) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Component getCustomEditor() {
        ColorPickerGrid colorPickerGrid = new ColorPickerGrid(Color.white);
        colorPickerGrid.setPEColor(this);
        return colorPickerGrid;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 400);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Frame getFrame() {
        Container container;
        for (container = this; container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        return (Frame)container;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        serializable = new PropertyChangeEvent(this, null, null, null);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((PropertyChangeListener)vector.elementAt(i2)).propertyChange((PropertyChangeEvent)serializable);
        }
    }
}

