/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class ColorTilePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int TILESIZE = 6;
    protected Vector _colors;
    protected int _selected = 0;
    protected int _nCols;
    protected boolean _allowSelection = true;
    protected ActionListener _onlyListener = null;
    public static Vector _NetscapeColors = null;

    public ColorTilePanel() {
        this(ColorTilePanel.netscapeColors());
    }

    public ColorTilePanel(int n2) {
        this(ColorTilePanel.netscapeColors(), n2);
    }

    public ColorTilePanel(Vector vector) {
        this._colors = vector;
        this._nCols = (int)Math.sqrt(vector.size());
        ColorTilePanel colorTilePanel = this;
        colorTilePanel.addMouseListener(colorTilePanel);
        ColorTilePanel colorTilePanel2 = this;
        colorTilePanel2.addMouseMotionListener(colorTilePanel2);
    }

    public ColorTilePanel(Vector vector, int n2) {
        this._colors = vector;
        this._nCols = n2;
        ColorTilePanel colorTilePanel = this;
        colorTilePanel.addMouseListener(colorTilePanel);
        ColorTilePanel colorTilePanel2 = this;
        colorTilePanel2.addMouseMotionListener(colorTilePanel2);
    }

    public Color getColor() {
        return (Color)this._colors.elementAt(this._selected);
    }

    public void setColor(Color color) {
        if (!this._colors.contains(color)) {
            return;
        }
        ColorTilePanel colorTilePanel = this;
        colorTilePanel.setSelectionIndex(colorTilePanel._colors.indexOf(color));
    }

    public void allowSelection(boolean bl2) {
        this._allowSelection = bl2;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        for (int i2 = 0; i2 < this._colors.size(); ++i2) {
            this.paintTile(graphics, i2);
        }
        this.showSelection(graphics);
    }

    public void paintTile(Graphics graphics, int n2) {
        graphics.setColor((Color)this._colors.elementAt(n2));
        int n3 = n2 % this._nCols;
        graphics.fillRect(n3 * 6, (n2 /= this._nCols) * 6, 6, 6);
    }

    public void showSelection(Graphics graphics) {
        Color color = (Color)this._colors.elementAt(this._selected);
        color = color.getRed() + color.getBlue() + color.getGreen() > 382 ? Color.black : Color.white;
        graphics.setColor(color);
        graphics.drawRect(this._selected % this._nCols * 6, this._selected / this._nCols * 6, 5, 5);
    }

    @Override
    public Dimension getMinimumSize() {
        int n2 = 6 * this._nCols;
        int n3 = 6 * (this._colors.size() / this._nCols + 2);
        return new Dimension(n2, n3);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean setSelectionIndex(int n2) {
        if (n2 < 0 || n2 > this._colors.size()) {
            return false;
        }
        if (n2 == this._selected) {
            return false;
        }
        this._selected = n2;
        this.repaint();
        return true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (n2 > this._nCols * 6 - 1 || n3 > this._colors.size() / this._nCols * 6 - 1) {
            return;
        }
        if (this.setSelectionIndex((n2 /= 6) + (n3 /= 6) * this._nCols)) {
            this.fireActionEvent(null);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static Vector netscapeColors() {
        if (_NetscapeColors == null) {
            int[] nArray = new int[6];
            int[] nArray2 = nArray;
            nArray[0] = 0;
            nArray2[1] = 51;
            nArray2[2] = 102;
            nArray2[3] = 153;
            nArray2[4] = 204;
            nArray2[5] = 255;
            _NetscapeColors = new Vector(216);
            for (int i2 = 0; i2 < 6; ++i2) {
                for (int i3 = 0; i3 < 6; ++i3) {
                    for (int i4 = 0; i4 < 6; ++i4) {
                        Color color = new Color(nArray2[i2], nArray2[i3], nArray2[i4]);
                        _NetscapeColors.addElement(color);
                    }
                }
            }
        }
        return _NetscapeColors;
    }

    public void addActionListener(ActionListener actionListener) {
        this._onlyListener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._onlyListener == actionListener) {
            this._onlyListener = null;
        }
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this._onlyListener != null) {
            this._onlyListener.actionPerformed(actionEvent);
        }
    }
}

