/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.undo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.tigris.gef.undo.Memento;

public class UndoManager {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private int undoMax = 100;
    private int undoChainCount = 0;
    private int redoChainCount = 0;
    private Collection mementoLocks = new ArrayList();
    private Collection listeners = new ArrayList();
    private boolean newChain = true;
    private boolean undoInProgress = false;
    protected ArrayList undoStack = new ArrayList();
    protected ArrayList redoStack = new ArrayList();
    private static UndoManager instance = new UndoManager();

    protected UndoManager() {
    }

    public static void setInstance(UndoManager undoManager) {
        undoManager.listeners = UndoManager.instance.listeners;
        instance = undoManager;
    }

    public static UndoManager getInstance() {
        return instance;
    }

    public void addMemento(Memento memento) {
        if (this.undoMax == 0) {
            return;
        }
        memento.startChain = this.newChain;
        if (this.newChain) {
            this.emptyRedo();
            this.incrementUndoChainCount();
            this.newChain = false;
        }
        this.undoStack.add(memento);
    }

    public void setUndoMax(int n2) {
        this.undoMax = n2;
    }

    public void undo() {
        boolean bl2;
        this.undoInProgress = true;
        do {
            UndoManager undoManager = this;
            Memento memento = undoManager.pop(undoManager.undoStack);
            bl2 = memento.isStartChain();
            this.undo(memento);
        } while (!bl2);
        this.decrementUndoChainCount();
        this.incrementRedoChainCount();
        this.undoInProgress = false;
    }

    protected void undo(Memento memento) {
        memento.undo();
        this.redoStack.add(memento);
    }

    public void redo() {
        this.undoInProgress = true;
        do {
            UndoManager undoManager = this;
            Memento memento = undoManager.pop(undoManager.redoStack);
            this.redo(memento);
        } while (this.redoStack.size() > 0 && !((Memento)this.redoStack.get((int)(this.redoStack.size() - 1))).startChain);
        this.incrementUndoChainCount();
        this.decrementRedoChainCount();
        this.undoInProgress = false;
    }

    protected void redo(Memento memento) {
        memento.redo();
        this.undoStack.add(memento);
    }

    public void emptyUndo() {
        if (this.undoChainCount > 0) {
            UndoManager undoManager = this;
            undoManager.emptyStack(undoManager.undoStack);
            this.undoChainCount = 0;
            this.fireCanUndo();
        }
    }

    private void emptyRedo() {
        if (this.redoChainCount > 0) {
            UndoManager undoManager = this;
            undoManager.emptyStack(undoManager.redoStack);
            this.redoChainCount = 0;
            this.fireCanRedo();
        }
    }

    public void empty() {
        this.emptyUndo();
        this.emptyRedo();
    }

    public void startChain() {
        this.newChain = true;
    }

    private void emptyStack(List list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ((Memento)list.get(i2)).dispose();
        }
        list.clear();
    }

    private Memento pop(ArrayList arrayList) {
        ArrayList arrayList2 = arrayList;
        return (Memento)arrayList2.remove(arrayList2.size() - 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    private void fireCanUndo() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UndoManager undoManager = this;
            ((PropertyChangeListener)iterator.next()).propertyChange(new PropertyChangeEvent(this, "canUndo", "", undoManager.getBoolString(undoManager.undoChainCount > 0)));
        }
    }

    private void fireCanRedo() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            UndoManager undoManager = this;
            ((PropertyChangeListener)iterator.next()).propertyChange(new PropertyChangeEvent(this, "canRedo", "", undoManager.getBoolString(undoManager.redoChainCount > 0)));
        }
    }

    private void incrementUndoChainCount() {
        if (++this.undoChainCount == 1) {
            this.fireCanUndo();
        }
    }

    private void decrementUndoChainCount() {
        if (--this.undoChainCount == 0) {
            this.fireCanUndo();
        }
    }

    private void incrementRedoChainCount() {
        if (++this.redoChainCount == 1) {
            this.fireCanRedo();
        }
    }

    private void decrementRedoChainCount() {
        if (--this.redoChainCount == 0) {
            this.fireCanRedo();
        }
    }

    private String getBoolString(boolean bl2) {
        if (bl2) {
            return TRUE;
        }
        return FALSE;
    }

    public boolean isUndoInProgress() {
        return this.undoInProgress;
    }

    public boolean isGenerateMementos() {
        return this.mementoLocks.size() == 0;
    }

    public void setGenerateMementos(boolean bl2) {
    }

    public void addMementoLock(Object object) {
        this.mementoLocks.add(object);
    }

    public void removeMementoLock(Object object) {
        this.mementoLocks.remove(object);
    }
}

