/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigris.gef.util.UnexpectedException;

public class Util {
    private Util() {
    }

    public static final String filenameToURI(String string) {
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && string.charAt(1) == ':' && (c2 = Character.toUpperCase(string.charAt(0))) >= 'A' && c2 <= 'Z') {
            string = "/".concat(String.valueOf(string));
        }
        return string;
    }

    public static final URL fileToURL(File file) {
        return new URL("file", "", Util.filenameToURI(file.getCanonicalPath()));
    }

    public static final URL fixURLExtension(URL uRL, String string) {
        if (!uRL.getFile().endsWith(string)) {
            try {
                uRL = new URL(uRL, uRL.getFile() + string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new UnexpectedException(malformedURLException);
            }
        }
        return uRL;
    }

    public static final URL exchangeURLExtension(URL uRL, String string, String string2) {
        if (!uRL.getFile().endsWith(string2)) {
            return Util.fixURLExtension(uRL, string);
        }
        try {
            string = uRL.getFile();
            string = string.substring(0, string.lastIndexOf(46));
            uRL = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnexpectedException(malformedURLException);
        }
        return uRL;
    }

    public static final String stripJunk(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3 && Character.isJavaIdentifierPart(string.charAt(n5))) {
            ++n5;
            ++n4;
        }
        if (n4 == n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(string.charAt(n2));
        }
        for (n2 = n4 + 1; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            n4 = c2;
            if (!Character.isJavaIdentifierPart(c2)) continue;
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public static final String URIToFilename(String string) {
        char c2;
        if (string.length() >= 3 && string.charAt(0) == '/' && string.charAt(2) == ':' && (c2 = Character.toUpperCase(string.charAt(1))) >= 'A' && c2 <= 'Z') {
            string = string.substring(1);
        }
        return string.replace('/', File.separatorChar);
    }

    public static final File URLToFile(URL uRL) {
        if (!"file".equals(uRL.getProtocol())) {
            throw new MalformedURLException("URL protocol must be 'file'.");
        }
        return new File(Util.URIToFilename(uRL.getFile()));
    }

    public static final String URLToShortName(URL uRL) {
        String string = uRL.getFile();
        return string.substring(string.lastIndexOf(47) + 1);
    }
}

