/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.domain;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.deversoft.odf.gearbox.common.domain.BusinessIndustry;
import ro.deversoft.odf.gearbox.common.domain.ResourceTypeClassifier;
import ro.deversoft.odf.gearbox.common.enums.EnumWithStringConstantAsTheName;

public enum ResourceType implements ResourceTypeClassifier,
EnumWithStringConstantAsTheName<ResourceType>
{
    ROOM(BusinessIndustry.RESERVABLE_DETERMINISTIC, "ROOM"),
    UMBRELLA_SPOT(BusinessIndustry.RESERVABLE_DETERMINISTIC, "UMBRELLA_SPOT"),
    PARKING_SPOT(BusinessIndustry.RESERVABLE_DETERMINISTIC, "PARKING_SPOT"),
    RESTAURANT_TABLE(BusinessIndustry.RESERVABLE_DETERMINISTIC, "RESTAURANT_TABLE"),
    FOOD(BusinessIndustry.CONSUMABLE, "FOOD"),
    DRINK(BusinessIndustry.CONSUMABLE, "DRINK"),
    LISTING(BusinessIndustry.LISTING_ONLY, "LISTING"),
    INSURANCE(BusinessIndustry.CONTRACTABLE_SERVICE, "INSURANCE"),
    OBJECT(BusinessIndustry.ANY, "OBJECT");

    private static final Map<BusinessIndustry, Set<ResourceType>> perBusinessIndustryResourceTypesGrouping;
    private String enumConstantStringName;
    private final BusinessIndustry businessIndustry;

    public static Set<ResourceType> catalogClassificationByBusinessIndustries(BusinessIndustry businessIndustry) {
        return perBusinessIndustryResourceTypesGrouping.get((Object)businessIndustry);
    }

    private ResourceType(BusinessIndustry bussinessIndustry, String strEnumValueName) {
        this.businessIndustry = bussinessIndustry;
        this.makeSureEnumConstantHasSameNameAsGivenStr(strEnumValueName);
    }

    @Override
    public String getEnumConstantStringName() {
        return this.enumConstantStringName;
    }

    @Override
    public ResourceType setEnumConstantStringName(String enumConstantStringName) {
        this.enumConstantStringName = enumConstantStringName;
        return this;
    }

    @Override
    public BusinessIndustry getBusinessIndustry() {
        return this.businessIndustry;
    }

    static {
        perBusinessIndustryResourceTypesGrouping = Stream.of(ResourceType.values()).collect(Collectors.groupingBy(ResourceType::getBusinessIndustry, Collectors.toSet()));
    }

    public static interface ResourceTypeEnumValueNames {
        public static final String ROOM = "ROOM";
        public static final String UMBRELLA_SPOT = "UMBRELLA_SPOT";
        public static final String PARKING_SPOT = "PARKING_SPOT";
        public static final String RESTAURANT_TABLE = "RESTAURANT_TABLE";
        public static final String FOOD = "FOOD";
        public static final String DRINK = "DRINK";
        public static final String LISTING = "LISTING";
        public static final String ECOSYSTEM_ENDPOINT = "ECOSYSTEM_ENDPOINT";
        public static final String INSURANCE = "INSURANCE";
        public static final String OBJECT = "OBJECT";
    }
}

