/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.gearbox.common.utils;

import java.util.Hashtable;
import java.util.Map;

public class QuickCache {
    Map<String, Map<Object, Object>> values = new Hashtable<String, Map<Object, Object>>();
    Map<String, MissCacheAction> actions = new Hashtable<String, MissCacheAction>();

    public void removeFromCache(String cacheName, Object key) {
        Map<Object, Object> currentCache = this.values.get(cacheName);
        if (currentCache != null) {
            currentCache.remove(key);
        }
    }

    public Object getFromCache(String cacheName, Object key) {
        MissCacheAction missCacheAction;
        Object val;
        if (key == null) {
            return null;
        }
        Map<Object, Object> currentCache = this.values.get(cacheName);
        if (currentCache == null) {
            currentCache = new Hashtable<Object, Object>();
            this.values.put(cacheName, currentCache);
        }
        if ((val = currentCache.get(key)) == null && (missCacheAction = this.actions.get(cacheName)) != null && (val = missCacheAction.getByKey(key)) != null) {
            currentCache.put(key, val);
        }
        return val;
    }

    public QuickCache registerCache(String name, MissCacheAction action) {
        this.resetCache(name);
        this.actions.put(name, action);
        return this;
    }

    public QuickCache resetCache(String name) {
        Map<Object, Object> valuesForCache = this.values.get(name);
        if (valuesForCache != null) {
            valuesForCache.clear();
        }
        return this;
    }

    public static interface MissCacheAction {
        public Object getByKey(Object var1);
    }
}

