package purejavacomm.testsuite;

import java.nio.ByteBuffer;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

public class Benchmark {
	final static int N = 10000;
	static CLibDM m_CLibDM;
	static CLib m_CLibIB;
	static CLib m_CLib;
	static long m_BytesN = 512;
	static byte[] m_Bytes = new byte[(int)m_BytesN];
	//static ByteBuffer m_BytesAsBuffer = ByteBuffer.wrap(m_Bytes);
	static Memory m_Memory = new Memory(m_BytesN);
	static public volatile int m_Dummy;

	public interface CLib extends com.sun.jna.Library {
		/* 1 */int htonl(int x);

		/* 2 */void memset(byte[] p, int c, long len);

		/* 2 */void memset(Pointer p, int c, long len);

		/* 3 */void memmove(byte[] d, byte[] s, long len);

		/* 4 */void memmove(Pointer d, Pointer s, long len);
	}

	public static class CLibDM implements CLib {
		/* 5 */native public int htonl(int x);

		/* 6 */native public void memset(byte[] p, int c, long len);

		/* 7 */native public void memset(Pointer p, int c, long len);

		/* 8 */native public void memmove(byte[] d, byte[] s, long len);

		/* 9 */native public void memmove(Pointer d, Pointer s, long len);

	}

	static void call_memset() {
		m_CLib.memset(m_Bytes, 69, m_BytesN);
	}

	static void call_memset2() {
		m_CLib.memset(m_Memory, 69, m_BytesN);
	}

	static void call_memmove() {
		m_CLib.memmove(m_Bytes, m_Bytes, m_BytesN);
	}

	static void call_memmove2() {
		m_CLib.memmove(m_Memory, m_Memory, m_BytesN);
	}

	static int call_htonl() {
		return m_CLib.htonl(0xDEADBEEF);
	}

	static int call_nothing() {
		return m_Dummy;
	}

	public static void runBenchmarks(double[] res, int offs) {
		long t0, dt;
		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_nothing();
		long bl = (System.nanoTime() - t0);

		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_htonl();
		res[offs++] = (System.nanoTime() - t0-bl) / N;

		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_memset();
		dt = System.nanoTime() - t0;
		res[offs++] = (System.nanoTime() - t0-bl) / N;

		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_memset2();
		dt = System.nanoTime() - t0;
		res[offs++] = (System.nanoTime() - t0-bl) / N;

		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_memmove();
		dt = System.nanoTime() - t0;
		res[offs++] = (System.nanoTime() - t0-bl) / N;

		t0 = System.nanoTime();
		for (int i = 0; i < N; i++)
			call_memmove2();
		dt = System.nanoTime() - t0;
		res[offs++] = (System.nanoTime() - t0-bl) / N;
	}

	public static void main(String[] args) {
		try {
			// to JIT add JVM argument -XX:+PrintCompilation -verbose:gc
			Native.register(CLibDM.class, NativeLibrary.getInstance("c"));
			m_CLibDM = new CLibDM();
			m_CLibIB = (CLib) Native.loadLibrary("c", CLib.class);

			double res[] = new double[10];
			for (int i = 0; i < 10000; i++) {

				m_CLib = m_CLibIB;
				runBenchmarks( res, 0);

				m_CLib = m_CLibDM;
				runBenchmarks(res, 5);

				for (int j = 0; j < res.length; ++j)
					System.out.printf("%15.3f", res[j] / 1000.0);
				System.out.println();
			}
			System.out.printf("%15s%15s%150s%15s%15s%15s\n", "IB/htonl", "IB/memset", "IB/memmove", "DM/htonl", "DM/htonl", "DM/memmove");
			System.out.printf("results in usec");
		} catch (Throwable t) {
			t.printStackTrace();
		}

	}
}

/*
 Results after some minutes on Mac BookPro Retina 2.6 GHz Intel Core i7 8 GB 1600 MHz DDR3 Mac OS X 10.8.5 jdk1.7.0_07
 
1.350          5.305          3.826          6.457          3.962          0.155          0.582          0.332          0.946          0.368
1.416          5.365          3.858          6.516          3.972          0.151          0.585          0.332          0.939          0.367
1.399          5.368          3.762          6.532          3.788          0.150          0.580          0.335          0.941          0.368
1.351          5.289          3.737          6.528          3.822          0.148          0.584          0.331          0.938          0.365
1.379          5.464          3.778          6.539          3.956          0.146          0.592          0.343          1.007          0.376
1.433          5.487          4.061          6.678          3.913          0.152          0.600          0.343          0.975          0.376
1.495          5.264          3.713          6.372          3.935          0.148          0.581          0.332          0.943          0.369
1.330          5.518          3.753          6.486          3.888          0.153          0.595          0.343          0.963          0.374
1.354          5.364          3.774          6.537          3.914          0.156          0.588          0.333          0.962          0.369
1.348          5.327          3.910          6.641          3.875          0.151          0.591          0.339          0.955          0.374
1.347          5.365          3.973          6.456          3.864          0.154          0.599          0.343          0.977          0.380
1.451          5.365          3.708          6.398          3.835          0.147          0.576          0.334          0.931          0.363
1.336          5.240          3.776          6.430          3.831          0.152          0.578          0.330          0.937          0.366
1.348          5.242          3.745          6.400          3.819          0.148          0.579          0.335          0.953          0.368
1.363          5.280          3.761          6.408          3.906          0.148          0.577          0.332          0.959          0.364
1.352          5.308          3.760          6.456          3.926          0.156          0.593          0.336          0.940          0.372
1.389          5.404          3.844          6.521          4.038          0.153          0.579          0.338          0.941          0.371
1.380          5.327          3.781          6.489          3.998          0.148          0.577          0.333          0.942          0.367
1.361          5.389          3.821          6.496          3.908          0.152          0.588          0.334          0.955          0.371
1.367          5.337          3.791          6.435          3.840          0.151          0.584          0.330          0.955          0.368
1.395          5.305          3.778          6.495          3.887          0.150          0.585          0.339          0.955          0.373
1.376          5.422          3.839          6.518          3.907          0.153          0.586          0.336          0.968          0.372
1.384          5.357          3.824          6.582          4.000          0.150          0.580          0.337          0.952          0.372
1.368          5.267          3.799          6.492          3.810          0.147          0.583          0.333          0.962          0.369
1.340          5.282          3.736          6.419          3.833          0.150          0.589          0.340          0.949          0.370
1.359          5.274          3.783          6.473          3.820          0.150          0.578          0.331          0.939          0.366
1.390          5.294          3.787          6.410          3.860          0.151          0.578          0.335          0.945          0.369
1.365          5.320          3.800          6.539          3.886          0.153          0.583          0.339          0.945          0.372
1.374          5.364          3.858          6.488          3.913          0.149          0.585          0.334          0.951          0.380
1.379          5.378          3.823          6.603          4.031          0.154          0.592          0.333          0.963          0.374

*/
