/*
 * Copyright (c) 2011, Kustaa Nyholm / SpareTimeLabs
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this list 
 * of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this 
 * list of conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 *  
 * Neither the name of the Kustaa Nyholm or SpareTimeLabs nor the names of its 
 * contributors may be used to endorse or promote products derived from this software 
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package purejavacomm.testsuite;

import purejavacomm.SerialPort;
import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;

public class TestYY extends TestBase {
	static void run() throws Exception {

		try {
			begin("Test10 - threshold performance ");
			System.setProperty("purejavacomm.rawreadmode", "false");
			openPort();

			m_Port.setSerialPortParams(230000, 8, 1, 0);
			m_Port.setFlowControlMode(SerialPort.FLOWCONTROL_XONXOFF_IN + SerialPort.FLOWCONTROL_XONXOFF_OUT);
			m_Out = m_Port.getOutputStream();
			m_In = m_Port.getInputStream();

			m_Port.enableReceiveTimeout(1000);
			final byte[] txbuffer = new byte[500];
			final byte[] rxbuffer = new byte[txbuffer.length];
			m_Port.enableReceiveThreshold(txbuffer.length);

			final int messages = 10000;
			final boolean[] done = { false };

			// Here create a thread that does read()s with threshold set to message length
			Thread rxthread = new Thread(new Runnable() {
				public void run() {
					try {
						long avg = 0;
						for (int i = 0; i < messages; i++) {
							long t0 = System.nanoTime();
							int rxn = m_In.read(rxbuffer, 0, txbuffer.length);
							long dt = System.nanoTime() - t0;
							avg += dt;
							if (true) {
								System.out.print(" received " + rxn + " bytes");
								System.out.print(" in " + (dt / 1000 / 1000.0) + " msec (average " + (avg / (i + 1) / 1000 / 1000.0) + ")");
								System.out.println();
							}
						}
						done[0] = true;
				} catch (Exception e) {
						e.printStackTrace();
					}

				}
			});

			System.out.println();

			rxthread.start();

			// here send the messages with pause in between messages
			for (int i = 0; i < messages; i++) {
				m_Out.write(txbuffer);
				//Thread.sleep(5);
			}
			while (!done[0])
				Thread.sleep(100);

			finishedOK();
		} finally {
			closePort();
		}

	}
}
